/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.sql.queries.SelectQuery;
import com.sun.rowset.FilteredRowSetImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.rowset.Predicate;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import officemate.adminkit.table.DefaultResultSetTableModel;
import ordermate.database.DBConnectionInterface;

public class QueryTableModel
extends DefaultResultSetTableModel {
    private static final int DESCENDING = -1;
    private static final int NOT_SORTED = 0;
    private static final int ASCENDING = 1;
    private int[] colSortStatus;
    private final transient MouseListener mouseListener;
    private JTableHeader tableHeader;
    private SelectQuery query;
    private String literalQuery;
    private List<Predicate> filterChain = new ArrayList<Predicate>();
    private DBConnectionInterface dc;

    public QueryTableModel(SelectQuery selQuery, DBConnectionInterface dataControl, String idField, String[] colNames, String[] colDisplayNames) {
        super(idField, colNames, colDisplayNames);
        if (colDisplayNames != null) {
            this.colSortStatus = new int[colDisplayNames.length];
        }
        this.mouseListener = new MouseHandler();
        this.query = selQuery;
        this.literalQuery = null;
        this.dc = dataControl;
    }

    public QueryTableModel(String selQuery, DBConnectionInterface dataControl, int idField, int[] colsToShow, String[] colDisplayNames) {
        super(idField, colsToShow, colDisplayNames);
        this.colSortStatus = new int[colDisplayNames.length];
        this.mouseListener = new MouseHandler();
        this.query = null;
        this.literalQuery = selQuery;
        this.dc = dataControl;
    }

    @Override
    public void setDisplayColumns(String[] dbColNames, String[] columnDisplayNames) {
        this.colSortStatus = new int[dbColNames.length];
        super.setDisplayColumns(dbColNames, columnDisplayNames);
    }

    public void addWhere(String whereCond) {
        if (this.query == null) {
            throw new IllegalStateException("Can't add WHERE condition, using literal query");
        }
        this.query.addWhere(whereCond);
    }

    public void removeWhere(String whereCond) {
        if (this.query == null) {
            throw new IllegalStateException("Can't remove WHERE condition, using literal query");
        }
        this.query.removeWhere(whereCond);
    }

    public void clearWhere() {
        if (this.query == null) {
            throw new IllegalStateException("Can't clear WHERE conditions, using literal query");
        }
        this.query.clearWhere();
    }

    public String getQueryString() {
        if (this.query != null) {
            return this.query.getSQL();
        }
        return this.literalQuery;
    }

    public SelectQuery getQuery() {
        return this.query;
    }

    public void setQuery(SelectQuery q) {
        this.query = q;
        this.literalQuery = null;
    }

    public void setQuery(String sql) {
        this.literalQuery = sql;
        this.query = null;
    }

    public void update() {
        try {
            ResultSet rs = this.dc.executeQuery(this.getQueryString());
            this.setData(rs);
            this.dc.release(rs);
        }
        catch (SQLException e) {
            OrderMateLog.LOG.error("SQL error updating SQL table : " + this.getQueryString(), (Throwable)e);
        }
    }

    public void update(Object[] params) {
        try {
            ResultSet rs = this.dc.executeQuery(this.getQueryString(), params);
            try {
                this.setData(rs);
            }
            finally {
                this.dc.release(rs);
            }
        }
        catch (SQLException e) {
            OrderMateLog.LOG.error("SQL error updating SQL table : " + this.getQueryString(), (Throwable)e);
        }
    }

    public void setTableHeader(JTableHeader header) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(defaultRenderer);
            }
        }
        this.tableHeader = header;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            if (!(this.tableHeader.getDefaultRenderer() instanceof SortableHeaderRenderer)) {
                this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
            }
        }
    }

    public int getSortingStatus(int column) {
        return this.colSortStatus[column];
    }

    public void setSortingStatus(int column, int status) {
        this.colSortStatus[column] = status;
        String dbColName = this.getDBColumnName(column);
        if (status == 1) {
            this.query.addOrderBy(dbColName, true);
        } else if (status == -1) {
            this.query.addOrderBy(dbColName, false);
        } else {
            this.query.removeOrderBy(dbColName);
        }
        this.onSortingStatusChanged();
    }

    private void cancelSorting() {
        this.query.clearOrderBy();
        for (int i = 0; i < this.colSortStatus.length; ++i) {
            this.colSortStatus[i] = 0;
        }
        this.onSortingStatusChanged();
    }

    private void onSortingStatusChanged() {
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void addClientFilter(Predicate filter) {
        if (filter != null) {
            this.filterChain.add(filter);
        }
    }

    public void clearClientFilters() {
        this.filterChain.clear();
    }

    private Icon getHeaderIcon(int modelColumn, int fontSize, int priority) {
        int sortStatus = this.colSortStatus[modelColumn];
        if (sortStatus == 1) {
            return new ArrowIcon(false, fontSize, priority);
        }
        if (sortStatus == -1) {
            return new ArrowIcon(true, fontSize, priority);
        }
        return null;
    }

    @Override
    public void setData(ResultSet rs) throws SQLException {
        ResultSet currentSet = rs;
        for (Predicate predicate : this.filterChain) {
            FilteredRowSetImpl filteredSet = new FilteredRowSetImpl();
            filteredSet.setFilter(predicate);
            filteredSet.populate(currentSet);
            currentSet = filteredSet;
        }
        super.setData(currentSet);
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer toWrap;

        public SortableHeaderRenderer(TableCellRenderer newToWrap) {
            this.toWrap = newToWrap;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int viewColumn) {
            Component toRender = this.toWrap.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, viewColumn);
            TableColumnModel columnModel = QueryTableModel.this.tableHeader.getColumnModel();
            if (viewColumn < columnModel.getColumnCount() && viewColumn > 0) {
                int column = columnModel.getColumn(viewColumn).getModelIndex();
                Icon icon = QueryTableModel.this.getHeaderIcon(column, toRender.getFont().getSize(), 1);
                if (toRender instanceof JLabel) {
                    ((JLabel)toRender).setIcon(icon);
                }
            }
            return toRender;
        }
    }

    private static class ArrowIcon
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public ArrowIcon(boolean desc, int fontSize, int arrowPriority) {
            this.descending = desc;
            this.size = fontSize;
            this.priority = arrowPriority;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int paramY) {
            int y = paramY;
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                int status = QueryTableModel.this.getSortingStatus(column);
                if (!e.isControlDown()) {
                    QueryTableModel.this.cancelSorting();
                }
                status += e.isShiftDown() ? -1 : 1;
                status = (status + 4) % 3 - 1;
                QueryTableModel.this.setSortingStatus(column, status);
            }
            QueryTableModel.this.update();
        }
    }
}

