/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.util.Assert;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class ResultSetTableModel
extends AbstractTableModel {
    private List<Long> ids = new ArrayList<Long>();
    private List data = new ArrayList();
    private String[] colNames;
    private int[] resultSetCols;
    private String[] colDisplayNames;
    private Number[] totalValues;
    private boolean[] useTotals;
    private String idField;
    private int idFieldIndex;
    private int rowCount = 0;

    public ResultSetTableModel(String dbIDField, String[] dbColNames, String[] columnDisplayNames) {
        this.idField = dbIDField;
        this.colNames = dbColNames;
        this.colDisplayNames = columnDisplayNames;
        int numCols = 0;
        if (this.colNames != this.colDisplayNames && (this.colNames == null || this.colDisplayNames == null)) {
            throw new IllegalStateException("Col names must be both null or the same length names : " + this.colNames + ", diplay names" + columnDisplayNames);
        }
        if (this.colNames != null || this.colDisplayNames != null) {
            Assert.isEqual((int)this.colNames.length, (int)this.colDisplayNames.length, (String)"Must be same number of column names and display names.");
            numCols = this.colDisplayNames.length;
        }
        this.totalValues = new Number[numCols];
        this.useTotals = new boolean[numCols];
    }

    public ResultSetTableModel(int dbIDField, int[] colsToShow, String[] columnDisplayNames) {
        this.idFieldIndex = dbIDField;
        this.resultSetCols = colsToShow;
        this.colDisplayNames = columnDisplayNames;
        Assert.isEqual((int)this.resultSetCols.length, (int)this.colDisplayNames.length, (String)"Must be same number of column names and display names.");
        int numCols = this.colDisplayNames.length;
        this.totalValues = new Number[numCols];
        this.useTotals = new boolean[numCols];
    }

    public void setDisplayColumns(String[] dbColNames, String[] columnDisplayNames) {
        this.colNames = dbColNames;
        this.colDisplayNames = columnDisplayNames;
        this.data = new ArrayList();
        this.ids = new ArrayList<Long>();
        this.resultSetCols = null;
        this.rowCount = 0;
        int numCols = this.colDisplayNames.length;
        this.totalValues = new Number[numCols];
        this.useTotals = new boolean[numCols];
        this.fireTableStructureChanged();
    }

    public void setData(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        this.data = new ArrayList();
        this.ids = new ArrayList<Long>();
        if (this.idField == null) {
            this.idField = metadata.getColumnName(this.idFieldIndex + 1);
        }
        if (this.colNames == null) {
            this.colNames = new String[this.resultSetCols.length];
            for (int i = 0; i < this.resultSetCols.length; ++i) {
                String tableName = metadata.getTableName(this.resultSetCols[i] + 1);
                String columnName = metadata.getColumnName(this.resultSetCols[i] + 1);
                this.colNames[i] = tableName.length() > 0 ? tableName + "." + columnName : columnName;
            }
        }
        if (this.resultSetCols == null) {
            this.resultSetCols = new int[this.colNames.length];
            int numResultSetCols = metadata.getColumnCount();
            for (int i = 0; i < numResultSetCols; ++i) {
                String tableName = metadata.getTableName(i + 1);
                String columnName = metadata.getColumnName(i + 1);
                String colName = tableName.length() > 0 ? tableName + "." + columnName : columnName;
                int displayIndex = -1;
                for (int j = 0; j < this.colNames.length; ++j) {
                    if (!this.colNames[j].equals(colName)) continue;
                    displayIndex = j;
                    break;
                }
                if (displayIndex == -1) continue;
                this.resultSetCols[displayIndex] = i;
            }
        }
        int numCols = this.colNames.length;
        Assert.isEqual((int)numCols, (int)this.colDisplayNames.length, (String)"Must be same number of column names and display names.");
        double[] tempTotals = new double[numCols];
        this.rowCount = 0;
        while (rs.next()) {
            Object[] row = new Object[numCols];
            if (this.idField != null) {
                this.ids.add(new Long(rs.getLong(this.idField)));
            }
            for (int i = 0; i < numCols; ++i) {
                if (this.colDisplayNames[i] != null) {
                    row[i] = this.getTableValue(this.rowCount, i, this.colNames[i], this.resultSetCols[i], rs);
                    if (!this.isTotalColumn(i) || !(row[i] instanceof Number)) continue;
                    int n = i;
                    tempTotals[n] = tempTotals[n] + ((Number)row[i]).doubleValue();
                    continue;
                }
                row[i] = null;
            }
            this.data.add(row);
            ++this.rowCount;
        }
        for (int i = 0; i < numCols; ++i) {
            this.totalValues[i] = this.getTotalValue(i, tempTotals[i], this.colNames[i], this.resultSetCols[i]);
        }
        this.fireTableDataChanged();
    }

    protected abstract Object getTableValue(int var1, int var2, String var3, int var4, ResultSet var5) throws SQLException;

    public Long getID(int row) {
        if (row >= 0 && row < this.ids.size()) {
            return this.ids.get(row);
        }
        return -1L;
    }

    public int getRow(Long id) {
        return this.ids.indexOf(id);
    }

    @Override
    public int getColumnCount() {
        return this.colDisplayNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isTotalColumn(int column) {
        return this.useTotals[column];
    }

    public void addTotalColumn(int column) {
        this.useTotals[column] = true;
    }

    public void addTotalResultSetColumn(int resultSetCol) {
        this.addTotalColumn(this.getColumnForResultSetCol(resultSetCol));
    }

    public void addTotalColumn(String dbColName) {
        int colIndex = this.getColumnForDBName(dbColName);
        if (colIndex <= 0) {
            throw new ArrayIndexOutOfBoundsException("Database column not found.");
        }
        this.addTotalColumn(colIndex);
    }

    public Number getTotal(String dbColName) {
        return this.getTotal(this.getColumnForDBName(dbColName));
    }

    public Number getTotal(int column) {
        return this.totalValues[column];
    }

    public Number getTotalForResultSetColumn(int resultSetCol) {
        return this.totalValues[this.getColumnForResultSetCol(resultSetCol)];
    }

    public Number[] getTotals() {
        return this.totalValues;
    }

    protected abstract Number getTotalValue(int var1, double var2, String var4, int var5);

    public int getColumnForResultSetCol(int resultSetCol) {
        for (int i = 0; i < this.resultSetCols.length; ++i) {
            if (this.resultSetCols[i] != resultSetCol) continue;
            return i;
        }
        return -1;
    }

    public int getColumnForDBName(String dbColumnName) {
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.colNames[i].equals(dbColumnName)) continue;
            return i;
        }
        return -1;
    }

    public int getColumnForDisplayName(String displayColumnName) {
        for (int i = 0; i < this.colDisplayNames.length; ++i) {
            if (!this.colDisplayNames[i].equals(displayColumnName)) continue;
            return i;
        }
        return -1;
    }

    public void clearTotals() {
        for (int i = 0; i < this.totalValues.length; ++i) {
            this.totalValues[i] = null;
        }
    }

    public void clearTotalColumns() {
        for (int i = 0; i < this.useTotals.length; ++i) {
            this.useTotals[i] = false;
        }
        this.clearTotals();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] row = (Object[])this.data.get(rowIndex);
        return row[columnIndex];
    }

    @Override
    public void setValueAt(Object obj, int rowIndex, int colIndex) {
        Object[] row = (Object[])this.data.get(rowIndex);
        row[colIndex] = obj;
        this.fireTableCellUpdated(rowIndex, colIndex);
    }

    protected static Object getResultSetObject(ResultSet rs, int rsCol) throws SQLException {
        return rs.getObject(rsCol + 1);
    }

    protected static String getResultSetString(ResultSet rs, int rsCol) throws SQLException {
        return rs.getString(rsCol + 1);
    }

    protected static int getResultSetInt(ResultSet rs, int rsCol) throws SQLException {
        return rs.getInt(rsCol + 1);
    }

    protected static double getResultSetDouble(ResultSet rs, int rsCol) throws SQLException {
        return rs.getDouble(rsCol + 1);
    }

    protected static long getResultSetLong(ResultSet rs, int rsCol) throws SQLException {
        return rs.getLong(rsCol + 1);
    }

    public String getDBColumnName(int column) {
        return this.colNames[column];
    }

    @Override
    public String getColumnName(int column) {
        return this.colDisplayNames[column];
    }
}

