/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.searchpanels.StockItemSearchPanel;
import officemate.adminkit.types.DateTimeFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.QuantityFieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.screens.maintainstock.waste.StockWastageEditorPanel;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.StockWastage;
import ordermate.database.users.User;

public class StockWastageTemplate
extends ObjectTemplate {
    public static final String USER = "User";
    public static final String STOCK_ITEM_ID = "Stock ID";
    public static final String STOCK_ITEM = "Stock Item";
    public static final String QUANTITY = "Quantity";
    public static final String STOCK_AREA = "Stock Area";
    public static final String USAGE_DATE = "Usage Date";
    public static final String REASON = "Reason";

    public StockWastageTemplate() {
        super("Stock Wastage", StockWastage.class);
        this.addEntry(USER, new ObjectRefFieldType(User.class, false, false, false, null), "user", "The user responsible for the wastage.");
        this.addEntry(STOCK_ITEM, new ObjectRefFieldType(StockItem.class, false, false, false, StockItemSearchPanel.class), "stockItem", "The stock item that had stock wasted.");
        this.addEntry(QUANTITY, new QuantityFieldType(0.0, 9999999.0, 1.0), "quantityUsed", "The quantity wasted.");
        this.addEntry(STOCK_AREA, new ObjectRefFieldType(StockArea.class, false, false, false, null), "stockArea", "The stock area the wasted stock was from.");
        this.addEntry(USAGE_DATE, new DateTimeFieldType(), "usageDate", "The date and time the stock was wasted.");
        this.addEntry(REASON, new StringFieldType(), "reason", "The reason given for the wastage.");
        this.setEditPanelClass(StockWastageEditorPanel.class);
    }
}

