/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.tree.ObjectMenuItem;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ObjectMenu
extends JMenu {
    public Signal objectSelected = Signals.createSignal(Object.class, (String)"selectedObj");
    private Object rootObj;
    private ObjectTemplate template;
    private ObjectFilter filter = null;

    public ObjectMenu(Object rootObject, ObjectTemplate objTemplate) {
        this(rootObject, objTemplate, null);
    }

    public ObjectMenu(Object rootObject, ObjectTemplate objTemplate, ObjectFilter objFilter) {
        super(objTemplate.getObjectText(rootObject));
        this.rootObj = rootObject;
        this.template = objTemplate;
        this.filter = objFilter;
        this.addMenuListener(new InnerMenuListener());
        this.buildTree();
    }

    private void buildTree() {
        if (this.filter == null || this.filter.accept(this.rootObj)) {
            List children = this.template.getObjectChildren(this.rootObj, this.filter);
            for (Object child : children) {
                if (!this.template.objectHasChildren(child)) {
                    ObjectMenuItem item = this.createObjectMenuItem(child);
                    item.addActionListener(new InnerMenuListener());
                    this.add(item);
                    continue;
                }
                ObjectMenu menu = this.createObjectMenu(child, this.filter);
                menu.objectSelected.connect((Object)this, "onObjectSelected");
                this.add(menu);
            }
        }
    }

    protected ObjectMenuItem createObjectMenuItem(Object userObject) {
        return new ObjectMenuItem(userObject, this.template);
    }

    protected ObjectMenu createObjectMenu(Object userObject, ObjectFilter menuFilter) {
        return new ObjectMenu(userObject, this.template, menuFilter);
    }

    public void onObjectSelected(Object selObj) {
        this.objectSelected.emit(selObj);
    }

    public ObjectTemplate getTemplate() {
        return this.template;
    }

    public Object getRootObject() {
        return this.rootObj;
    }

    public void refresh() {
        this.removeAll();
        this.buildTree();
    }

    private class InnerMenuListener
    implements ActionListener,
    MenuListener {
        private InnerMenuListener() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            ObjectMenu.this.onObjectSelected(ObjectMenu.this.rootObj);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            Object selObject = ObjectMenu.this.rootObj;
            if (source instanceof ObjectMenuItem) {
                selObject = ((ObjectMenuItem)source).getRootObject();
            }
            ObjectMenu.this.onObjectSelected(selObject);
        }
    }
}

