/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree;

import au.com.ordermate.util.Assert;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.tree.DefaultObjectTree;

public abstract class ObjectTreeSelectorPanel
extends ObjectSelectorPanel {
    protected DefaultObjectTree tree;
    private JScrollPane scroller;
    protected ObjectTemplate template;

    protected abstract List getRootObjects(ObjectTemplate var1);

    @Override
    public void init(ObjectTemplate objTemplate, boolean allowsNull) {
        Assert.isTrue((objTemplate.getChildProperty() != null ? 1 : 0) != 0, (String)("ObjectTemplate \"" + objTemplate + "\" does not support a tree structure."));
        List objects = this.getRootObjects(objTemplate);
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            Assert.isTrue((boolean)objTemplate.objectBelongs(o), (String)("Object <" + o + "> does not match template \"" + objTemplate + "\", can't add to tree"));
        }
        this.template = objTemplate;
        this.removeAll();
        this.setLayout(new GridLayout(1, 1));
        this.tree = new DefaultObjectTree(objects, objTemplate);
        this.scroller = new JScrollPane(this.tree, 20, 30);
        JPanel wrapper = new JPanel(new GridLayout(1, 1));
        wrapper.setPreferredSize(new Dimension(200, 300));
        wrapper.add(this.scroller);
        this.scroller.getHorizontalScrollBar().setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.tree.setRootVisible(allowsNull);
        this.tree.getObjectTreeModel().getRootNode().setUserObject("(top level)");
        this.add(wrapper);
    }

    @Override
    public Object getSelectedObject() {
        return this.tree.getSelectedObject();
    }

    @Override
    public Class getExpectedJavaClass() {
        return this.template.getObjectJavaClass();
    }

    @Override
    public boolean setSelectedObject(Object obj) {
        Object oldSelObject = this.getSelectedObject();
        if (this.tree.setSelectedObject(obj)) {
            if (obj == null && oldSelObject != null || obj != null && !obj.equals(oldSelObject)) {
                this.objectSelected.emit(obj, (Object)this);
            }
            return true;
        }
        return false;
    }

    public ObjectFilter getObjectFilter() {
        return this.tree.getObjectFilter();
    }

    public void setObjectFilter(ObjectFilter f) {
        this.tree.setObjectFilter(f);
    }

    @Override
    public void updateView() {
        this.tree.revalidate();
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.tree;
    }
}

