/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree.stockgroup;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.AWTError;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import officemate.adminkit.tree.stockgroup.StockGroupTree;
import officemate.screens.setup.stock.items.StockItemGuiHelper;
import ordermate.OrderMate;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockGroup;

public class StockGroupTreeCrudSupport {
    private static final Cursor MOVE_CURSOR = StockGroupTreeCrudSupport.loadCursor("DnD.Cursor.MoveDrop");
    private static final Cursor NO_MOVE_CURSOR;
    private static final Cursor DEFAULT_CURSOR;
    private StockGroupTree tree;
    private JPopupMenu editStockGroupMenu;
    private JMenuItem newItem;
    private JMenuItem editItem;
    private JMenuItem deleteItem;

    public StockGroupTreeCrudSupport(StockGroupTree tree) {
        this.tree = tree;
        InnerMouseListener ml = new InnerMouseListener();
        tree.addMouseListenerToTree(ml);
        tree.addMouseMotionListenerToTree(ml);
        this.editStockGroupMenu = new JPopupMenu();
        this.newItem = new JMenuItem("New...");
        this.editItem = new JMenuItem("Rename...");
        this.deleteItem = new JMenuItem("Delete");
        MenuListener menuListener = new MenuListener();
        this.newItem.addActionListener(menuListener);
        this.editItem.addActionListener(menuListener);
        this.deleteItem.addActionListener(menuListener);
        this.editStockGroupMenu.add(this.newItem);
        this.editStockGroupMenu.add(this.editItem);
        this.editStockGroupMenu.add(this.deleteItem);
    }

    private static Cursor loadCursor(String name) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        try {
            return (Cursor)Toolkit.getDefaultToolkit().getDesktopProperty(name);
        }
        catch (AWTError e) {
            OrderMate.LOG.error("failed to load system cursor: " + name + " : " + e.getMessage(), (Throwable)e);
            throw new IllegalStateException("failed to load system cursor: " + name + " : " + e.getMessage(), e);
        }
    }

    private void createStockGroup(StockGroup parentGroup) {
        String newStockGroupName = JOptionPane.showInputDialog(this.tree.getTreeGuiComponent(), "Enter new stock group name:", "New Stock Group", 3);
        if (newStockGroupName != null) {
            StockGroup newGroup = new StockGroup();
            if (parentGroup != null) {
                newGroup.setParentGroup(parentGroup);
            }
            newGroup.setLabel(newStockGroupName);
            newGroup.save();
            this.tree.refresh();
            this.tree.setSelectedObject(newGroup);
        }
    }

    private void renameStockGroup(StockGroup group) {
        String newStockGroupName = JOptionPane.showInputDialog(this.tree.getTreeGuiComponent(), "Enter new name:", group.getName());
        if (newStockGroupName != null) {
            group.setLabel(newStockGroupName);
            group.save();
            this.tree.refresh();
            this.tree.setSelectedObject(group);
        }
    }

    private void deleteStockGroup(StockGroup group) {
        if (group.getItemsWithStockOnHand().size() > 0) {
            JOptionPane.showMessageDialog(this.tree.getTreeGuiComponent(), "Cannot delete a group with stock on hand for " + group.getItemsWithStockOnHand().size() + " item(s).");
            return;
        }
        if (StockItemGuiHelper.allowDeleteItems(group.getStockItems()) && StockItemGuiHelper.deleteAllSafeStockItems(group.getStockItems())) {
            StockItemQueries.clearCache();
            group.save();
            group = (StockGroup)PersistenceManager.reacquire((PersistentObjectI)group);
        }
        if (group.getStockItems().isEmpty()) {
            TreePath parentPath = this.tree.getTreeGuiComponent().getSelectionPath().getParentPath();
            group.delete();
            this.tree.refresh();
            this.tree.getTreeGuiComponent().setSelectionPath(parentPath);
            this.tree.getTreeGuiComponent().expandPath(parentPath);
        }
    }

    private void moveStockGroup(StockGroup draggedGroup, StockGroup mouseOverGroup) {
        draggedGroup.setParentGroup(mouseOverGroup);
        draggedGroup.save();
        this.tree.refresh();
        this.tree.setSelectedObject(draggedGroup);
    }

    static {
        DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
        NO_MOVE_CURSOR = StockGroupTreeCrudSupport.loadCursor("DnD.Cursor.MoveNoDrop");
    }

    private class InnerMouseListener
    extends MouseInputAdapter {
        private StockGroup draggedGroup = null;
        private StockGroup mouseOverGroup = null;
        private boolean rootDragged = false;

        private InnerMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkIsRoot();
            StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().setSelectionPath(StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().getPathForLocation(e.getX(), e.getY()));
            this.showPopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.draggedGroup == null) {
                this.checkIsRoot();
                this.showPopupMenu(e);
            } else {
                if (this.isValidDrag(e)) {
                    StockGroupTreeCrudSupport.this.moveStockGroup(this.draggedGroup, this.mouseOverGroup);
                }
                this.draggedGroup = null;
            }
            this.rootDragged = false;
            StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().setCursor(DEFAULT_CURSOR);
            this.mouseOverGroup = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            StockGroup groupAtXY = this.getStockGroupForEvent(e);
            if (!this.rootDragged) {
                if (this.draggedGroup == null) {
                    this.mouseOverGroup = null;
                    this.draggedGroup = groupAtXY;
                    TreeNode nodeHere = this.getNodeForEvent(e);
                    if (nodeHere != null && nodeHere instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)nodeHere).isRoot()) {
                        this.rootDragged = true;
                        StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().setCursor(NO_MOVE_CURSOR);
                    } else {
                        StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().setCursor(MOVE_CURSOR);
                    }
                } else {
                    this.mouseOverGroup = groupAtXY;
                    StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().setCursor(this.isValidDrag(e) ? MOVE_CURSOR : NO_MOVE_CURSOR);
                }
            }
        }

        private boolean isValidDrag(MouseEvent e) {
            TreeNode obj = this.getNodeForEvent(e);
            if (obj instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                return node != null && node.isRoot() || this.mouseOverGroup != null && !this.mouseOverGroup.equals((Object)this.draggedGroup) && !this.mouseOverGroup.isSubGroupOf(this.draggedGroup);
            }
            if (obj instanceof StockGroup) {
                StockGroup node = (StockGroup)obj;
                return node != null && this.isRoot(node) || this.mouseOverGroup != null && !this.mouseOverGroup.equals((Object)this.draggedGroup) && !this.mouseOverGroup.isSubGroupOf(this.draggedGroup);
            }
            return obj instanceof TreeNode;
        }

        private TreeNode getNodeForEvent(MouseEvent e) {
            TreePath pathAtXY = StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().getPathForLocation(e.getX(), e.getY());
            if (pathAtXY != null) {
                return (TreeNode)pathAtXY.getLastPathComponent();
            }
            return null;
        }

        private StockGroup getStockGroupForEvent(MouseEvent e) {
            TreeNode obj = this.getNodeForEvent(e);
            if (obj == null) {
                return null;
            }
            if (obj instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode nodeAtXY = (DefaultMutableTreeNode)obj;
                if (nodeAtXY != null && !nodeAtXY.isRoot()) {
                    return (StockGroup)nodeAtXY.getUserObject();
                }
                return null;
            }
            if (obj instanceof StockGroup) {
                return (StockGroup)obj;
            }
            return null;
        }

        private boolean checkIsRoot() {
            TreePath selPath = StockGroupTreeCrudSupport.this.tree.getTreeGuiComponent().getSelectionPath();
            boolean isRoot = selPath == null;
            StockGroupTreeCrudSupport.this.editItem.setEnabled(!isRoot);
            StockGroupTreeCrudSupport.this.deleteItem.setEnabled(!isRoot);
            return isRoot;
        }

        private void showPopupMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                StockGroupTreeCrudSupport.this.editStockGroupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public boolean isRoot(StockGroup node) {
            return !StockGroup.getTopLevelStockGroups().contains(node);
        }
    }

    public class MenuListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObject = StockGroupTreeCrudSupport.this.tree.getSelectedObject();
            StockGroup selectedGroup = null;
            if (selectedObject instanceof StockGroup) {
                selectedGroup = (StockGroup)selectedObject;
            }
            if (e.getSource() == StockGroupTreeCrudSupport.this.newItem) {
                StockGroupTreeCrudSupport.this.createStockGroup(selectedGroup);
            } else if (e.getSource() == StockGroupTreeCrudSupport.this.editItem) {
                StockGroupTreeCrudSupport.this.renameStockGroup(selectedGroup);
            } else if (e.getSource() == StockGroupTreeCrudSupport.this.deleteItem) {
                StockGroupTreeCrudSupport.this.deleteStockGroup(selectedGroup);
            }
        }
    }
}

