/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.tree.stockgroup;

import au.com.ordermate.util.image.IconLoader;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.tree.DefaultObjectTree;
import officemate.adminkit.tree.stockgroup.StockGroupTree;
import officemate.adminkit.tree.stockgroup.StockGroupTreeCrudSupport;
import ordermate.database.stock.StockGroup;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class StockGroupTreePanel
extends JPanel
implements StockGroupTree {
    public final Signal objectSelected = Signals.createSignal(Object.class, (String)"selectedObj");
    private DefaultObjectTree tree;

    public StockGroupTreePanel(ObjectManager manager) {
        this(manager, true);
    }

    public StockGroupTreePanel(ObjectManager manager, boolean showRoot) {
        super(new GridLayout(1, 1));
        ObjectTemplate stockGroupTemplate = manager.getTemplate(StockGroup.class);
        List stockGroups = StockGroupTreePanel.getTopLevelStockGroups();
        this.tree = new DefaultObjectTree(stockGroups, stockGroupTemplate);
        new StockGroupTreeCrudSupport(this);
        OfficeMateAdminGuiUtils.getInstance().standardTreeSetup(this.tree);
        this.tree.setRootVisible(showRoot);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(IconLoader.get((String)"/ordermate/images/group_red.png"));
        renderer.setOpenIcon(IconLoader.get((String)"/ordermate/images/red_folder.png"));
        renderer.setClosedIcon(IconLoader.get((String)"/ordermate/images/red_folder.png"));
        this.tree.setCellRenderer(renderer);
        this.tree.objectSelected.connect((Object)this, "gotObjectSelected");
        JScrollPane scroller = new JScrollPane(this.tree, 20, 30);
        scroller.setFocusable(false);
        scroller.getHorizontalScrollBar().setFocusable(false);
        scroller.getVerticalScrollBar().setFocusable(false);
        this.add(scroller);
    }

    public void refresh() {
        this.tree.setRootObjects(StockGroupTreePanel.getTopLevelStockGroups());
    }

    public static List getTopLevelStockGroups() {
        List topLevelStockGroups = StockGroup.getTopLevelStockGroups();
        return topLevelStockGroups;
    }

    void gotObjectSelected(Object o) {
        this.objectSelected.emit(o);
    }

    public DefaultObjectTree getTree() {
        return this.tree;
    }

    @Override
    public Object getSelectedObject() {
        return this.tree.getSelectedObject();
    }

    public ObjectFilter getObjectFilter() {
        return this.tree.getObjectFilter();
    }

    public void setObjectFilter(ObjectFilter filter) {
        this.tree.setObjectFilter(filter);
    }

    @Override
    public void addMouseListenerToTree(MouseListener ml) {
        this.tree.addMouseListener(ml);
    }

    @Override
    public void addMouseMotionListenerToTree(MouseMotionListener ml) {
        this.tree.addMouseMotionListener(ml);
    }

    @Override
    public JTree getTreeGuiComponent() {
        return this.tree;
    }

    @Override
    public void setSelectedObject(StockGroup group) {
        this.tree.setSelectedObject(group);
    }
}

