/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import au.com.ordermate.OrderMateLog;
import java.util.List;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectEditorAdaptorFieldPanel;
import officemate.adminkit.types.FieldType;

public class BusinessObjectType
implements FieldType {
    private Class type;
    private Class defaultType;

    public BusinessObjectType(Class newType, Class concreteType) {
        if (newType == null) {
            throw new IllegalArgumentException("new type cannot be null");
        }
        this.type = newType;
        this.defaultType = concreteType;
    }

    @Override
    public TableCellEditor getCellEditor(List items) {
        return null;
    }

    @Override
    public final Object getDefaultInitValue() {
        try {
            Class typeToConstruct = this.defaultType != null ? this.defaultType : this.type;
            return typeToConstruct.newInstance();
        }
        catch (Exception ex) {
            OrderMateLog.LOG.error("Creation of business object failed", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Class getJavaClass() {
        return this.type;
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        ObjectEditorAdaptorFieldPanel panel = new ObjectEditorAdaptorFieldPanel(manager, manager.getTemplate(this.type));
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        return value != null && this.getJavaClass().isAssignableFrom(value.getClass());
    }
}

