/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.types;

import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.DoubleFieldPanel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.FieldType;

public class DoubleFieldType
implements FieldType {
    private Double min;
    private Double max;
    private Double def;

    public DoubleFieldType() {
        this.def = null;
        this.max = null;
        this.min = null;
    }

    public DoubleFieldType(double defaultVal) {
        this.def = new Double(defaultVal);
        this.max = null;
        this.min = null;
    }

    public DoubleFieldType(double minVal, double maxVal, double defaultVal) {
        this.min = new Double(minVal);
        this.max = new Double(maxVal);
        this.def = new Double(defaultVal);
    }

    @Override
    public TableCellEditor getCellEditor(List objectList) {
        return new DefaultCellEditor(new JTextField());
    }

    public Double getMinValue() {
        return this.min;
    }

    public Double getMaxValue() {
        return this.max;
    }

    public Double getDefaultValue() {
        return this.def;
    }

    @Override
    public Class getJavaClass() {
        return Double.class;
    }

    @Override
    public Object getDefaultInitValue() {
        return this.def != null ? this.def : new Double(0.0);
    }

    public String toString() {
        return "Double";
    }

    @Override
    public FieldPanel getPanel(ObjectManager manager) {
        DoubleFieldPanel panel = new DoubleFieldPanel();
        panel.setFieldType(this);
        return panel;
    }

    @Override
    public boolean isValidValue(Object value) {
        return value != null && value instanceof Double;
    }
}

