/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.GraphPaperLayout;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class AddRemovePanel<T>
extends JPanel
implements ActionListener {
    public Signal<Object, Boolean, ?, ?, ?> changed = Signals.createSignal(Object.class, (String)"whatChanged", Boolean.class, (String)"addedOrRemoved");
    protected JList poolList;
    protected JList addedList;
    protected JButton addButton;
    protected JButton removeButton;
    private SortedList<T> pool;
    protected SortedList<T> added;
    private EventList<T> baseAdded;
    private DuplicatePolicy duplicatePolicy = DuplicatePolicy.Deny;

    public AddRemovePanel() {
        super((LayoutManager)new GraphPaperLayout(22, 20));
        this.setupComponents();
        this.addComponents();
    }

    public AddRemovePanel(int height, int width) {
        super((LayoutManager)new GraphPaperLayout(new Dimension(width, height), 0, 2));
        this.setupComponents();
    }

    public void setDuplicatePolicy(DuplicatePolicy policy) {
        this.duplicatePolicy = policy;
    }

    private void setupComponents() {
        this.pool = new SortedList((EventList)new BasicEventList());
        this.baseAdded = new BasicEventList();
        this.added = new SortedList((EventList)this.baseAdded);
        this.poolList = new JList(new EventListModel(this.pool));
        this.poolList.setSelectionMode(2);
        this.addedList = new JList(new EventListModel(this.added));
        this.addedList.setSelectionMode(2);
        this.addButton = new JButton(">");
        this.removeButton = new JButton("<");
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
    }

    private void addComponents() {
        this.add((Component)new JScrollPane(this.poolList), new Rectangle(0, 0, 9, 22));
        this.add((Component)this.addButton, new Rectangle(10, 1, 2, 2));
        this.add((Component)this.removeButton, new Rectangle(10, 4, 2, 2));
        this.add((Component)new JScrollPane(this.addedList), new Rectangle(13, 0, 9, 22));
    }

    private void add(Object[] toAdd) {
        if (toAdd != null) {
            this.added.getReadWriteLock().writeLock().lock();
            for (Object nextAdd : toAdd) {
                if (DuplicatePolicy.Allow.equals((Object)this.duplicatePolicy)) {
                    this.added.add(0, nextAdd);
                } else if (this.added.contains(nextAdd)) {
                    if (DuplicatePolicy.MoveToStart.equals((Object)this.duplicatePolicy)) {
                        this.added.remove(nextAdd);
                        this.added.add(0, nextAdd);
                    } else if (DuplicatePolicy.MoveToEnd.equals((Object)this.duplicatePolicy)) {
                        this.added.remove(nextAdd);
                        this.added.add(nextAdd);
                    }
                } else {
                    this.added.add(nextAdd);
                }
                this.changed.emit(nextAdd, (Object)Boolean.TRUE);
            }
            this.added.getReadWriteLock().writeLock().unlock();
        }
        this.addedList.repaint();
        this.poolList.repaint();
    }

    protected void remove(Object[] toRemove) {
        if (toRemove != null) {
            this.added.getReadWriteLock().writeLock().lock();
            for (Object nextRemove : toRemove) {
                this.added.remove(nextRemove);
                this.changed.emit(nextRemove, (Object)Boolean.FALSE);
            }
            this.added.getReadWriteLock().writeLock().unlock();
            this.addedList.repaint();
            this.poolList.repaint();
        }
    }

    public int getRawIndex(T addedItem) {
        return this.baseAdded.indexOf(addedItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.add(this.poolList.getSelectedValues());
        } else if (e.getSource() == this.removeButton) {
            this.remove(this.addedList.getSelectedValues());
        }
    }

    public void setPoolList(List<? extends T> thePool) {
        GlazedListUtils.setAsList(this.pool, thePool);
    }

    public void setAddedList(List<T> currentList) {
        GlazedListUtils.setAsList(this.added, currentList);
    }

    public List<T> getPoolList() {
        this.pool.getReadWriteLock().readLock().lock();
        ArrayList<T> result = new ArrayList<T>(this.pool);
        this.pool.getReadWriteLock().readLock().unlock();
        return result;
    }

    public List<T> getAddedList() {
        this.added.getReadWriteLock().readLock().lock();
        ArrayList<T> result = new ArrayList<T>(this.added);
        this.added.getReadWriteLock().readLock().unlock();
        return result;
    }

    public void setPoolRenderer(ListCellRenderer renderer) {
        this.poolList.setCellRenderer(renderer);
    }

    public void setAddedRenderer(ListCellRenderer renderer) {
        this.addedList.setCellRenderer(renderer);
    }

    public void setPoolComparator(Comparator<T> comparator) {
        this.pool.setComparator(comparator);
    }

    public void setAddedComparator(Comparator<T> comparator) {
        this.added.setComparator(comparator);
    }

    public static enum DuplicatePolicy {
        Allow,
        Deny,
        MoveToStart,
        MoveToEnd;

    }
}

