/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import officemate.components.ObjectLabel;
import officemate.components.controls.ColourSelector;
import officemate.components.controls.FileSelectionFieldPanel;
import officemate.components.controls.NullableIntegerFormatter;
import officemate.components.controls.NullableNumberFormatter;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.LimitedColorSelector;
import ordermate.gui.binding.BindingHelper;
import ordermate.gui.binding.converter.NullableIntToStringConverter;
import ordermate.gui.binding.converter.NullableLongToStringConverter;
import ordermate.gui.binding.converter.NullableNumToStringConverter;
import ordermate.gui.binding.validators.NumericalValidator;
import ordermate.gui.binding.validators.PositiveIntValidator;
import ordermate.gui.binding.validators.PriceValidator;
import ordermate.gui.model.NullableEventComboBoxModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.JXDatePicker;

public class BindingGuiSupportPanel<T>
extends JPanel {
    private BindingHelper<T> helper;
    public final Signal objectEdited = Signals.createSignal();
    private ObjectEditedListener listener;

    public BindingGuiSupportPanel() {
        this.listener = new ObjectEditedListener();
    }

    public BindingGuiSupportPanel(BindingHelper<T> bindingHelper, ObjectEditedListener objectEditedListener) {
        this.helper = bindingHelper;
        this.listener = objectEditedListener;
    }

    protected BindingHelper<T> getBindings() {
        if (this.helper == null) {
            this.helper = new BindingHelper();
            this.helper.bridgePropertyValid((JComponent)this);
        }
        return this.helper;
    }

    public boolean isGuiValid() {
        return this.getBindings().isGuiValid();
    }

    protected void setBindings(BindingHelper<T> bindingHelper) {
        if (this.helper != null) {
            throw new IllegalStateException("This editor already has a bindingHelper");
        }
        this.helper = bindingHelper;
        this.helper.bridgePropertyValid((JComponent)this);
    }

    protected ObjectEditedListener getListener() {
        if (this.listener == null) {
            this.listener = new ObjectEditedListener();
        }
        return this.listener;
    }

    public final Binding addBoundRow(FieldPanelBuilder builder, String rowLabelText, JComponent guiComponent, PropertiedObject.Property bindSource, String bindTarget) {
        Binding binding = this.getBindings().createBinding(bindSource, (Object)guiComponent, bindTarget);
        builder.addRow(rowLabelText, (Component)guiComponent);
        return binding;
    }

    protected JSpinner setupTimeSpinner(PropertiedObject.Property propToBind) {
        JSpinner spinner = new JSpinner();
        this.getBindings().createIntegerBinding(propToBind, spinner, 0, 7200, 0);
        spinner.addChangeListener(this.listener);
        return spinner;
    }

    protected JCheckBox setupCheckBox(PropertiedObject.Property booleanPropToBind) {
        JCheckBox box = new JCheckBox();
        box.setName(booleanPropToBind.getName());
        this.getBindings().createBinding(booleanPropToBind, (Object)box, "selected");
        box.addActionListener(this.listener);
        return box;
    }

    protected <E> JComboBox setupComboBox(PropertiedObject.Property optionPropToBind, EventList<E> options) {
        return this.setupComboBox(optionPropToBind, (ComboBoxModel)new EventComboBoxModel(options), null);
    }

    protected JComboBox setupComboBoxByIndex(PropertiedObject.Property optionPropToBind, ComboBoxModel modelToUse, Validator validator) {
        JComboBox box = new JComboBox(modelToUse);
        box.setName(optionPropToBind.getName());
        ComponentUtils.setupComboBox(box);
        Binding binding = this.getBindings().createBinding(optionPropToBind, box, "selectedIndex");
        if (validator != null) {
            binding.setValidator(validator);
        }
        box.addActionListener(this.listener);
        return box;
    }

    protected JComboBox setupComboBox(PropertiedObject.Property optionPropToBind, ComboBoxModel modelToUse, Validator validator) {
        JComboBox box = new JComboBox(modelToUse);
        box.setName(optionPropToBind.getName());
        ComponentUtils.setupComboBox(box);
        Binding binding = this.getBindings().createBinding(optionPropToBind, box, "selectedItem");
        if (validator != null) {
            binding.setValidator(validator);
        }
        box.addActionListener(this.listener);
        return box;
    }

    protected JComboBox setupNullableComboBox(PropertiedObject.Property optionPropToBind, EventList eventList, final String nullPlaceholder) {
        JComboBox box = this.setupComboBox(optionPropToBind, (ComboBoxModel)new NullableEventComboBoxModel(eventList, (Object)nullPlaceholder), null);
        box.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    ((DefaultListCellRenderer)comp).setText(nullPlaceholder);
                }
                return comp;
            }
        });
        return box;
    }

    private JSpinner bindSpinner(JSpinner spinner, PropertiedObject.Property propToBind) {
        Binding binding = this.getBindings().createBinding(propToBind, (Object)spinner, "value");
        binding.addBindingListener((BindingListener)this.listener);
        return spinner;
    }

    protected JTextField setupTextField(PropertiedObject.Property propToBind, int numCols, Validator validator) {
        JTextField field = new JTextField(numCols);
        field.setName(propToBind.getName());
        Binding binding = this.bindTextField(field, propToBind, "text");
        binding.setValidator(validator);
        return field;
    }

    protected FileSelectionFieldPanel setupDirectoryField(PropertiedObject.Property propToBind, int numCols, Validator validator) {
        FileSelectionFieldPanel panel = new FileSelectionFieldPanel(numCols, null, true);
        panel.setName(propToBind.getName());
        Binding binding = this.bindTextField(panel.getTextField(), propToBind, "text");
        binding.setValidator(validator);
        return panel;
    }

    protected FileSelectionFieldPanel setupFileField(PropertiedObject.Property propToBind, int numCols, String description, String[] extensions, Validator validator) {
        FileNameExtensionFilter fileFilter = null;
        if (extensions != null) {
            fileFilter = new FileNameExtensionFilter(description, extensions);
        }
        FileSelectionFieldPanel panel = new FileSelectionFieldPanel(numCols, fileFilter, false);
        panel.setName(propToBind.getName());
        Binding binding = this.bindTextField(panel.getTextField(), propToBind, "text");
        binding.setValidator(validator);
        return panel;
    }

    protected JPasswordField setupPasswordField(PropertiedObject.Property password, int numCols, Validator validator) {
        JPasswordField passwordField = new JPasswordField(numCols);
        Binding passwordBinding = this.getBindings().createBinding(password.getName(), (Object)passwordField, "text");
        passwordBinding.setValidator(validator);
        return passwordField;
    }

    protected JPasswordField setupPasswordField(PropertiedObject.Property password, int numCols) {
        return this.setupPasswordField(password, numCols, null);
    }

    protected JTextField setupTextField(PropertiedObject.Property propToBind, int numCols) {
        return this.setupTextField(propToBind, numCols, null);
    }

    protected Binding bindTextField(JTextField field, PropertiedObject.Property propToBind, String guiTargetProp) {
        Binding binding = this.getBindings().createBinding(propToBind, (Object)field, guiTargetProp);
        binding.addBindingListener((BindingListener)this.listener);
        return binding;
    }

    protected JTextArea setupTextArea(PropertiedObject.Property propToBind, int columns, int rows, Validator validator) {
        JTextArea area = new JTextArea(rows, columns);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setName(propToBind.getName());
        Binding binding = this.getBindings().createBinding(propToBind, (Object)area, "text");
        binding.addBindingListener((BindingListener)this.listener);
        if (validator != null) {
            binding.setValidator(validator);
        }
        return area;
    }

    protected JTextField setupPriceField(PropertiedObject.Property<Price> propToBind, int numCols) {
        JFormattedTextField field = this.constructPriceField(numCols);
        field.setName(propToBind.getName());
        Binding binding = this.bindTextField(field, propToBind, "value");
        binding.setValidator((Validator)new PriceValidator());
        return field;
    }

    protected JFormattedTextField constructPriceField(int numCols) {
        JFormattedTextField field = new JFormattedTextField(new PriceFormatter());
        field.setColumns(numCols);
        field.getDocument().addDocumentListener(this.listener);
        return field;
    }

    protected JLabel setupLabel(PropertiedObject.Property property) {
        return this.setupLabel(property, "object");
    }

    protected JLabel setupLabel(PropertiedObject.Property property, String lableName) {
        ObjectLabel label = new ObjectLabel();
        AutoBinding.UpdateStrategy strategy = this.getBindings().getStrategy();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ);
        this.getBindings().createBinding(property, (Object)label, lableName);
        this.getBindings().setStrategy(strategy);
        return label;
    }

    public JFormattedTextField setupNumberField(PropertiedObject.Property toBind, int columns, Double min, Double max, String format) {
        JFormattedTextField field = new JFormattedTextField(new NullableNumberFormatter());
        field.getDocument().addDocumentListener(this.listener);
        Binding binding = this.bindTextField(field, toBind, "value");
        if (columns > 0) {
            field.setColumns(columns);
        }
        binding.setValidator((Validator)new NumericalValidator((Number)min, (Number)max, Double.class));
        binding.setConverter((Converter)new NullableNumToStringConverter());
        return field;
    }

    public JFormattedTextField setupLongField(PropertiedObject.Property toBind, int columns, Long min, Long max) {
        JFormattedTextField field = new JFormattedTextField(new NullableIntegerFormatter());
        field.getDocument().addDocumentListener(this.listener);
        field.setName(toBind.getName());
        Binding binding = this.bindTextField(field, toBind, "value");
        if (columns > 0) {
            field.setColumns(columns);
        }
        binding.setConverter((Converter)new NullableLongToStringConverter());
        binding.setValidator((Validator)new NumericalValidator((Number)min, (Number)max, Long.class));
        return field;
    }

    public JFormattedTextField setupPositiveIntegerField(PropertiedObject.Property toBind, int columns, boolean acceptZero, boolean acceptEmpty) {
        return this.setupIntegerField(toBind, columns, (Validator)new PositiveIntValidator(acceptZero, acceptEmpty));
    }

    public JFormattedTextField setupIntegerField(PropertiedObject.Property toBind, int columns, Validator validator) {
        JFormattedTextField field = new JFormattedTextField(new NullableIntegerFormatter());
        field.setName(toBind.getName());
        Binding binding = this.bindTextField(field, toBind, "text");
        if (columns >= 1) {
            field.setColumns(columns);
        }
        binding.setConverter((Converter)new NullableIntToStringConverter());
        binding.setValidator(validator);
        return field;
    }

    public ColourSelector setupColorSelection(PropertiedObject.Property toBind) {
        ColourSelector selector = new ColourSelector(null);
        selector.setName(toBind.getName());
        Binding binding = this.getBindings().createBinding(toBind, (Object)selector, "color");
        binding.addBindingListener((BindingListener)this.listener);
        return selector;
    }

    protected LimitedColorSelector setupLimitedColorSelector(PropertiedObject.Property toBind, boolean allowNull) {
        LimitedColorSelector colorSelector = new LimitedColorSelector(false);
        colorSelector.allowNull(allowNull);
        Binding binding = this.getBindings().createBinding(toBind, colorSelector.getComboBox(), "selectedItem");
        binding.addBindingListener((BindingListener)this.getListener());
        colorSelector.addActionListener((ActionListener)this.listener);
        return colorSelector;
    }

    protected LimitedColorSelector setupAnyColorSelector(PropertiedObject.Property toBind, boolean allowNull) {
        LimitedColorSelector selector = this.setupLimitedColorSelector(toBind, allowNull);
        selector.setAvailableColors(null);
        selector.setColorChooserVisible(true);
        selector.setColorChooserEnabled(true);
        return selector;
    }

    protected JSpinner setupDateSpinner(PropertiedObject.Property propToBind, String format, Date start, Date end) {
        SpinnerDateModel model = new SpinnerDateModel();
        model.setValue(new Date());
        if (start != null) {
            model.setStart(start);
        }
        if (end != null) {
            model.setEnd(end);
        }
        JSpinner spinner = new JSpinner(model);
        if (format != null) {
            spinner.setEditor(new JSpinner.DateEditor(spinner, format));
        }
        return this.bindSpinner(spinner, propToBind);
    }

    protected JXDatePicker setupDatePicker(PropertiedObject.Property propToBind) {
        JXDatePicker datePicker = new JXDatePicker();
        this.getBindings().createBinding(propToBind, (Object)datePicker, "date");
        datePicker.addActionListener((ActionListener)this.listener);
        return datePicker;
    }

    @Deprecated
    protected JSpinner setupSQLTimeSpinner(PropertiedObject.Property propToBind, String format) {
        SpinnerSQLTimeModel model = new SpinnerSQLTimeModel();
        model.setValue(new Date());
        JSpinner spinner = new JSpinner(model);
        spinner.setName(propToBind.getName());
        if (format != null) {
            spinner.setEditor(new JSpinner.DateEditor(spinner, format));
        }
        return this.bindSpinner(spinner, propToBind);
    }

    protected JSpinner setupIntSpinner(PropertiedObject.Property propToBind, Number stepSize, Integer min, Integer max, Integer def, int numCols) {
        SpinnerNumberModel model = new SpinnerNumberModel();
        if (min != null) {
            model.setMinimum(min);
        }
        if (max != null) {
            model.setMaximum(max);
        }
        if (stepSize != null) {
            model.setStepSize(stepSize);
        }
        JSpinner spinner = new JSpinner(model);
        spinner.setName(propToBind.getName());
        if (def != null) {
            spinner.setValue(def);
        } else if (min != null) {
            spinner.setValue(min);
        } else if (max != null) {
            spinner.setValue(max);
        } else {
            spinner.setValue(new Integer(0));
        }
        if (numCols > 0) {
            ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setColumns(numCols);
        }
        return this.bindSpinner(spinner, propToBind);
    }

    protected JSpinner setupNumberSpinner(PropertiedObject.Property propToBind, Number stepSize, Double min, Double max, Double def, String format, int numCols) {
        SpinnerNumberModel SNM = new SpinnerNumberModel();
        if (stepSize != null) {
            SNM.setStepSize(stepSize);
        }
        if (min != null) {
            SNM.setMinimum(min);
            SNM.setValue(min);
        }
        if (stepSize != null) {
            SNM.setStepSize(stepSize);
        }
        if (max != null) {
            SNM.setMaximum(max);
            SNM.setValue(max);
        }
        JSpinner spinner = new JSpinner(SNM);
        spinner.setName(propToBind.getName());
        if (def != null) {
            spinner.setValue(def);
        } else if (min != null) {
            spinner.setValue(min);
        } else if (max != null) {
            spinner.setValue(max);
        } else {
            spinner.setValue(new Double(0.0));
        }
        if (format != null) {
            spinner.setEditor(new JSpinner.NumberEditor(spinner, format));
        }
        if (numCols > 0) {
            ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setColumns(numCols);
        }
        return this.bindSpinner(spinner, propToBind);
    }

    public static class PriceFormatter
    extends JFormattedTextField.AbstractFormatter {
        @Override
        public Object stringToValue(String text) throws ParseException {
            try {
                return Price.parsePrice((String)text);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Not a valid Price:" + text, 0);
            }
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value != null) {
                return value.toString();
            }
            return "";
        }
    }

    protected class ObjectEditedListener
    implements ActionListener,
    ChangeListener,
    BindingListener,
    DocumentListener {
        private boolean fireEvents = false;

        public void setFireEvents(boolean fire) {
            this.fireEvents = fire;
        }

        public void fireObjectEdited() {
            if (this.fireEvents) {
                BindingGuiSupportPanel.this.objectEdited.emit();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireObjectEdited();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireObjectEdited();
        }

        public void bindingBecameBound(Binding binding) {
        }

        public void bindingBecameUnbound(Binding binding) {
        }

        public void syncFailed(Binding binding, Binding.SyncFailure failure) {
            this.fireObjectEdited();
        }

        public void synced(Binding binding) {
            this.fireObjectEdited();
        }

        public void sourceChanged(Binding binding, PropertyStateEvent event) {
            this.fireObjectEdited();
        }

        public void targetChanged(Binding binding, PropertyStateEvent event) {
            this.fireObjectEdited();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.fireObjectEdited();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.fireObjectEdited();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.fireObjectEdited();
        }
    }

    @Deprecated
    protected static class SpinnerSQLTimeModel
    extends SpinnerDateModel {
        protected SpinnerSQLTimeModel() {
        }

        @Override
        public Object getValue() {
            return new Time(((Date)super.getValue()).getTime());
        }
    }
}

