/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CompositeList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import officemate.components.ListPropertyObjectEditor;

public abstract class ChooseListElementsObjectEditor<P, L>
extends ListPropertyObjectEditor<P, L> {
    private EventList possibleElements;
    private final EventList missingElements;
    private JCheckBoxCellRenderer renderer;
    private final JList list;

    public ChooseListElementsObjectEditor(EventList<L> thePossibleElements) {
        this.possibleElements = thePossibleElements;
        this.missingElements = new BasicEventList(this.possibleElements.getPublisher(), this.possibleElements.getReadWriteLock());
        CompositeList modelList = new CompositeList(this.possibleElements.getPublisher(), this.possibleElements.getReadWriteLock());
        modelList.addMemberList(this.possibleElements);
        modelList.addMemberList(this.missingElements);
        this.list = new JList(new EventListModel((EventList)modelList));
        this.renderer = JCheckBoxCellRenderer.install((JList)this.list);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.list), "Center");
    }

    @Override
    public void setObject(P toEdit) {
        super.setObject(toEdit);
        this.missingElements.clear();
        for (Object nextObj : this.getParentList()) {
            if (this.possibleElements.contains(nextObj)) continue;
            this.missingElements.add(nextObj);
        }
        this.setGuiList(this.getParentList());
    }

    public void setRenderer(JCheckBoxCellRenderer newRenderer) {
        this.list.removeListSelectionListener((ListSelectionListener)this.renderer);
        this.renderer = newRenderer;
        this.list.setCellRenderer(this.renderer);
        this.list.addListSelectionListener((ListSelectionListener)this.renderer);
    }

    @Override
    public Collection<L> getGuiList() {
        return new ArrayList(this.renderer.getSelectedElements());
    }

    @Override
    public void setGuiList(Collection toDisplay) {
        this.renderer.setSelectedElements(toDisplay);
    }

    public void setPossibleElements(EventList<L> thePossibleElements) {
        this.possibleElements = thePossibleElements;
    }
}

