/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.gui.ObjectEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import officemate.components.AbstractObjectEditor;
import ordermate.gui.binding.BindingHelper;
import org.jdesktop.beansbinding.AutoBinding;

public class CompositeObjectEditor<T>
extends AbstractObjectEditor<T> {
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final List<ObjectEditor<T>> objectEditors = new ArrayList<ObjectEditor<T>>();

    public CompositeObjectEditor(AbstractObjectEditor<T> masterEditorPanel) {
        BindingHelper helper = new BindingHelper(AutoBinding.UpdateStrategy.READ_WRITE);
        helper.bridgePropertyValid((JComponent)this);
        this.setBindings(helper);
        this.setLayout(new BorderLayout());
        if (masterEditorPanel != null) {
            JComponent masterPanel = masterEditorPanel.getComponent();
            this.objectEditors.add(masterEditorPanel);
            this.add((Component)masterPanel, "North");
        }
        this.add((Component)this.tabbedPane, "Center");
    }

    public CompositeObjectEditor() {
        this((AbstractObjectEditor<T>)null);
    }

    public void addObjectEditorTab(String title, AbstractObjectEditor<T> editor) {
        if (!editor.getBindings().equals(this.getBindings())) {
            throw new IllegalArgumentException("child editor should have the same bindings as composite editor.  Pass composite editors bindings into child editors constructor.");
        }
        this.addObjectEditorTabUnsafe(title, editor);
    }

    public void addObjectEditorTabUnsafe(String title, ObjectEditor editor) {
        this.tabbedPane.addTab(title, editor.getComponent());
        this.objectEditors.add(editor);
        if (editor instanceof AbstractObjectEditor) {
            ((AbstractObjectEditor)editor).objectEdited.connect((Object)this, "gotObjectEdited");
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void gotObjectEdited() {
        if (this.isGuiValid()) {
            this.saveObject();
            this.objectEdited.emit();
        }
    }

    @Override
    public BindingHelper<T> getBindings() {
        return super.getBindings();
    }

    @Override
    public void refresh() {
        super.refresh();
        for (ObjectEditor<T> editor : this.objectEditors) {
            if (!(editor instanceof AbstractObjectEditor)) continue;
            ((AbstractObjectEditor)editor).refresh();
        }
    }
}

