/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXHeader;

public class EditorDialog {
    private boolean okClicked = false;
    private JFrame applicationFrame;
    private JXHeader header;
    private JDialog theDialog = new JDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
    private final BasicAction okAction;

    public EditorDialog(ObjectEditor theEditor) {
        this("", theEditor);
    }

    public EditorDialog(String typeName, ObjectEditor theEditor) {
        this(typeName, theEditor, "", "");
    }

    public EditorDialog(String typeName, final JComponent comp, String title, String headerTitle) {
        this.applicationFrame = GuiApp.getAppComplex().getApplicationFrame().getFrame();
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.setModal(true);
        if (title.isEmpty()) {
            this.theDialog.setTitle("Edit " + typeName);
        } else {
            this.theDialog.setTitle(title);
        }
        this.theDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JComponent component = (JComponent)EditorDialog.this.theDialog.getFocusTraversalPolicy().getDefaultComponent(comp);
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }
        });
        String headerText = this.getHeaderText(typeName, headerTitle);
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 3));
        this.header = new JXHeader(this.theDialog.getTitle(), headerText);
        headerPane.add((Component)this.header);
        headerPane.add(new JSeparator());
        this.theDialog.add((Component)headerPane, "First");
        JComponent centreComponent = comp;
        centreComponent.setPreferredSize(null);
        JScrollPane pane = new JScrollPane(centreComponent);
        pane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.theDialog.add((Component)pane, "Center");
        final JButton okButton = new JButton();
        this.okAction = new BasicAction("Ok"){

            public void actionPerformed(ActionEvent e) {
                if (this.isEnabled()) {
                    EditorDialog.this.theDialog.setVisible(false);
                    EditorDialog.this.okClicked = true;
                } else {
                    okButton.setEnabled(false);
                }
            }
        };
        okButton.setAction((Action)this.okAction);
        this.theDialog.getRootPane().setDefaultButton(okButton);
        BasicAction cancelAction = new BasicAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.theDialog.setVisible(false);
                EditorDialog.this.okClicked = false;
            }
        };
        JButton cancelButton = new JButton((Action)cancelAction);
        this.theDialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), cancelAction.getText());
        this.theDialog.getRootPane().getActionMap().put(cancelAction.getText(), (Action)cancelAction);
        JPanel buttonBar = ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton);
        buttonBar.setBorder(Borders.DIALOG_BORDER);
        this.theDialog.add((Component)buttonBar, "Last");
        this.theDialog.pack();
    }

    public EditorDialog(String typeName, ObjectEditor theEditor, String title, String headerTitle) {
        this(typeName, theEditor.getComponent(), title, headerTitle);
        BeanProperty guiValidProperty = BeanProperty.create((String)"guiValid");
        BeanProperty enabledProperty = BeanProperty.create((String)"enabled");
        this.okAction.setEnabled(false);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)theEditor, (Property)guiValidProperty, (Object)this.okAction, (Property)enabledProperty);
        binding.setSourceObject((Object)theEditor);
        binding.bind();
    }

    private String getHeaderText(String typeName, String headerTitle) {
        String headerText = headerTitle;
        if (headerText.isEmpty()) {
            if (!typeName.isEmpty()) {
                headerText = "You can use this screen to edit a " + typeName + ". ";
            }
            headerText = headerText + "To save your changes click 'Ok', to forget them click 'Cancel'.";
        }
        if (!headerText.toLowerCase().startsWith("<html")) {
            headerText = "<html>" + headerText + "</html>";
        }
        return headerText;
    }

    public boolean doModal() {
        this.okClicked = false;
        this.theDialog.pack();
        Dimension size = this.theDialog.getSize();
        double screenHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int frameHeight = this.applicationFrame.getHeight();
        if ((double)size.height > screenHeight) {
            this.theDialog.setSize(this.theDialog.getWidth(), (int)screenHeight - 50);
        } else if (size.height > frameHeight) {
            this.theDialog.setSize(this.theDialog.getWidth(), frameHeight - 20);
        }
        this.theDialog.setLocationRelativeTo(this.applicationFrame);
        this.theDialog.setVisible(true);
        return this.getOkClicked();
    }

    public boolean getOkClicked() {
        return this.okClicked;
    }

    public void setHeaderText(String newText) {
        this.header.setDescription(newText);
    }

    protected String getEditHeaderText() {
        return this.header.getDescription();
    }

    public void setDefaultButton(JButton button) {
        this.theDialog.getRootPane().setDefaultButton(button);
    }

    public void setResizable(boolean resizable) {
        this.theDialog.setResizable(resizable);
    }
}

