/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public abstract class ListEditor<E>
extends JPanel
implements ActionListener {
    private JList guiList;
    private JButton addBut;
    private JButton removeBut;
    private List<E> oldList;
    private List<E> list;

    public ListEditor() {
        this.setupComponents();
    }

    protected void updateGuiList() {
        this.guiList.setListData(this.list.toArray());
        this.firePropertyChange("list", this.oldList, this.list);
    }

    public List<E> getList() {
        return this.list;
    }

    public void setList(List<E> newList) {
        this.oldList = this.list;
        this.list = new ArrayList<E>(newList);
        this.updateGuiList();
    }

    protected E getSelectedObject() {
        return this.guiList.getSelectedValue();
    }

    private void setupComponents() {
        this.setLayout(new BorderLayout());
        this.guiList = new JList();
        this.guiList.setListData(new Object[0]);
        JScrollPane scrolly = new JScrollPane(this.guiList);
        scrolly.setPreferredSize(new Dimension(120, 60));
        this.add((Component)scrolly, "Center");
        JPanel butPanel = new JPanel();
        this.addBut = new JButton("Add...");
        butPanel.add(this.addBut);
        this.removeBut = new JButton("Remove");
        butPanel.add(this.removeBut);
        this.addBut.addActionListener(this);
        this.removeBut.addActionListener(this);
        this.add((Component)butPanel, "South");
    }

    protected void gotRemove() {
        E selection = this.getSelectedObject();
        if (selection != null) {
            this.removeObject(selection);
        }
    }

    protected void removeObject(E toRemove) {
        this.oldList = this.list;
        this.list = new ArrayList<E>(this.list);
        this.list.remove(toRemove);
        this.updateGuiList();
    }

    protected abstract void gotAdd();

    protected void addObject(E toAdd) {
        if (toAdd != null && !this.list.contains(toAdd)) {
            this.oldList = this.list;
            this.list = new ArrayList();
            this.list.add(toAdd);
            this.list.addAll(this.oldList);
            this.updateGuiList();
            this.guiList.setSelectedValue(toAdd, true);
        }
    }

    public void setVisibleRowCount(int rowCount) {
        this.guiList.setVisibleRowCount(rowCount);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addBut) {
            this.gotAdd();
        } else if (source == this.removeBut) {
            this.gotRemove();
        }
    }

    @Override
    public void setEnabled(boolean value) {
        this.addBut.setEnabled(value);
        this.removeBut.setEnabled(value);
        super.setEnabled(value);
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.guiList.setCellRenderer(cellRenderer);
    }
}

