/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.gui.ObjectEditor;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JScrollPane;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.AbstractObjectEditor;
import officemate.components.strategy.SaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import ordermate.database.users.Permission;

public abstract class ObjectEditorState<T>
extends BasicOfficeMateState {
    private SaveStrategy strategy = SaveStrategyFactory.getInstantSaveStrategy();
    private boolean initCalled = false;
    private AbstractObjectEditor<T> editor;

    protected abstract T acquireObject();

    public ObjectEditorState(String stateName, Permission permission, String description) {
        super(stateName, permission, description);
    }

    protected abstract AbstractObjectEditor<T> createObjectEditor();

    @Override
    public void onStart() {
        this.init();
        this.setObjectToEdit(this.acquireObject());
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void refresh() {
        this.setObjectToEdit(this.acquireObject());
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        this.editor = this.createObjectEditor();
        this.editor.objectEdited.connect((Object)this, "gotObjectEdited");
        this.setScreenPanel(new JScrollPane(this.editor.getComponent()));
        Iterator<Action> it = this.strategy.getActions().iterator();
        while (it.hasNext()) {
            this.addAction(it.next());
        }
        super.init();
        this.initCalled = true;
    }

    protected void setSaveStrategy(SaveStrategy theStrategy) {
        this.strategy = theStrategy;
    }

    protected ObjectEditor<T> getObjectEditor() {
        return this.editor;
    }

    protected void setObjectToEdit(T obj) {
        this.editor.setObject(obj);
    }

    public void gotObjectEdited() {
        this.strategy.objectNeedsSaving(this.editor.getObject());
    }
}

