/*
 * Decompiled with CFR 0.152.
 */
package officemate.components;

import au.com.ordermate.persistence.Displayable;
import ca.odell.glazedlists.EventList;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class PersistentDisplayableHighlighter
extends AbstractHighlighter {
    private EventList modelList;
    private JXTable table;

    public PersistentDisplayableHighlighter(EventList newModelList, JXTable tableToHighlight) {
        this.modelList = newModelList;
        this.table = tableToHighlight;
    }

    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        Color newCol;
        if (this.modelList.size() == 0) {
            return component;
        }
        JComponent comp = adapter.getComponent();
        Displayable displayable = (Displayable)this.modelList.get(this.table.convertRowIndexToModel(adapter.row));
        if (displayable.getBackgroundColor() != null) {
            newCol = ColorUtil.interpolate((Color)component.getBackground(), (Color)displayable.getBackgroundColor(), (float)0.7f);
            component.setBackground(newCol);
        }
        if (displayable.getForegroundColor() != null) {
            newCol = ColorUtil.interpolate((Color)component.getBackground(), (Color)displayable.getBackgroundColor(), (float)0.7f);
            component.setForeground(newCol);
        }
        return component;
    }
}

