/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import officemate.OfficeMate;
import officemate.components.controls.NullableColourChooser;

public class ColourSelector
extends JLabel {
    private Color color;

    public ColourSelector() {
        this(Color.white);
    }

    public ColourSelector(Color c) {
        Border border = LineBorder.createBlackLineBorder();
        this.setBorder(border);
        this.setPreferredSize(new Dimension(40, 20));
        this.setOpaque(true);
        this.color = c;
        this.setBackground(this.color);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ColourSelector.this.isEnabled()) {
                    Color newColor = NullableColourChooser.getInstance().selectNullableColour(OfficeMate.getApplicationFrame(), ColourSelector.this.color);
                    ColourSelector.this.setColor(newColor);
                }
            }
        });
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newColor) {
        Color oldColor = this.color;
        this.color = newColor;
        this.setBackground(newColor);
        if (oldColor != newColor) {
            this.firePropertyChange("color", oldColor, newColor);
        }
    }
}

