/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.abstracts.SingleValueSearchAdapter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.FlowLayout;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JPanel;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class ComboDateRangePanel
extends JPanel {
    private ComboSearchField startDatePicker;
    private ComboSearchField endDatePicker;
    private PeriodReportAdapter period;
    private final EventList<Date> datesStart;
    private final EventList<Date> datesEnd;

    public ComboDateRangePanel(Date start, Date end, PeriodReportAdapter period, IRangedQuerySearchFilter<Date> filter, RefreshAction refreshAction) {
        super(new FlowLayout(10, 0, 0));
        this.period = period;
        this.datesStart = GlazedLists.eventList((Collection)period.getDateList());
        this.datesEnd = GlazedLists.eventList((Collection)period.getDateList());
        StartRangeFilter startFilter = new StartRangeFilter(filter);
        EndRangeFilter endFilter = new EndRangeFilter(filter);
        this.startDatePicker = this.makePicker("Start date:", "startDate", "startDateField", start, (ISingleValueSearchFilter<Date>)startFilter, refreshAction, this.datesStart);
        this.endDatePicker = this.makePicker("End date:", "endDate", "endDateField", end, (ISingleValueSearchFilter<Date>)endFilter, refreshAction, this.datesEnd);
        JPanel startPanel = new JPanel();
        startPanel.add(this.startDatePicker.getJLabelForComponent());
        startPanel.add(this.startDatePicker.getGuiComponent());
        JPanel endPanel = new JPanel();
        endPanel.add(this.endDatePicker.getJLabelForComponent());
        endPanel.add(this.endDatePicker.getGuiComponent());
        this.add(startPanel);
        this.add(endPanel);
    }

    private ComboSearchField makePicker(String fieldLabel, String comboName, String editorName, Date calendar, ISingleValueSearchFilter<Date> filter, RefreshAction refreshAction, EventList<Date> dates) {
        ComboSearchField picker = new ComboSearchField(fieldLabel, filter, false, (Action)refreshAction, dates, (Format)this.period.getFormatter());
        picker.getGuiComponent().setName(comboName);
        picker.getGuiComponent().getEditor().getEditorComponent().setName(editorName);
        if (dates.contains((Object)calendar)) {
            picker.setSearchValue((Object)calendar);
        }
        return picker;
    }

    public void refresh() {
        GlazedListUtils.setAsList(this.datesStart, new ArrayList(this.period.getDateList()));
        GlazedListUtils.setAsList(this.datesEnd, new ArrayList(this.period.getDateList()));
    }

    public void addAction(Action action) {
        if (action != null) {
            this.startDatePicker.addAction(action);
            this.endDatePicker.addAction(action);
        }
    }

    public void setDates(Calendar start, Calendar end) {
        this.setDates(start.getTime(), end.getTime());
    }

    public void setDates(Date startDate, Date endDate) {
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public void setStartDate(Date start) {
        this.startDatePicker.setSelectedObject((Object)start);
    }

    public void setEndDate(Date end) {
        this.endDatePicker.setSelectedObject((Object)end);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.startDatePicker.getGuiComponent().setEnabled(enabled);
        this.endDatePicker.getGuiComponent().setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.startDatePicker != null && this.endDatePicker != null && this.startDatePicker.getGuiComponent() != null && this.endDatePicker.getGuiComponent() != null && this.startDatePicker.getGuiComponent().isEnabled() && this.endDatePicker.getGuiComponent().isEnabled();
    }

    public ComboSearchField getStartSearchField() {
        return this.startDatePicker;
    }

    public ComboSearchField getEndSearchField() {
        return this.endDatePicker;
    }

    public String getUnitString() {
        return this.period.getUnitOfTime();
    }

    private static class EndRangeFilter
    extends SingleValueSearchAdapter<Date> {
        private final IRangedQuerySearchFilter<Date> filter;

        public EndRangeFilter(IRangedQuerySearchFilter<Date> filter) {
            super(filter);
            this.filter = filter;
        }

        public void setSearchValue(Date value) {
            this.filter.setEnd((Comparable)value);
        }

        public Date getSearchValue() {
            return (Date)this.filter.getEnd();
        }
    }

    private static class StartRangeFilter
    extends SingleValueSearchAdapter<Date> {
        private final IRangedQuerySearchFilter<Date> filter;

        public StartRangeFilter(IRangedQuerySearchFilter<Date> filter) {
            super(filter);
            this.filter = filter;
        }

        public void setSearchValue(Date value) {
            this.filter.setStart((Comparable)value);
        }

        public Date getSearchValue() {
            return (Date)this.filter.getStart();
        }
    }
}

