/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls;

import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import officemate.components.controls.NullableIntegerFormatter;
import ordermate.OrderMate;

public class IntegerRangePanel
extends JPanel {
    public static final String LOWER_LABEL = "Lower";
    public static final String UPPER_LABEL = "Upper";
    private JFormattedTextField lowerField;
    private JFormattedTextField upperField;
    private Action action;
    private static final int FIELD_COLUMNS = 5;

    public IntegerRangePanel() {
        this.setupComponents();
    }

    private void setupComponents() {
        JPanel lowerPanel = new JPanel();
        lowerPanel.add(new JLabel(LOWER_LABEL));
        this.lowerField = new JFormattedTextField(new NullableIntegerFormatter());
        lowerPanel.add(this.lowerField);
        this.addCommittingAction(this.lowerField);
        JPanel upperPanel = new JPanel();
        upperPanel.add(new JLabel(UPPER_LABEL));
        this.upperField = new JFormattedTextField(new NullableIntegerFormatter());
        upperPanel.add(this.upperField);
        this.addCommittingAction(this.upperField);
        this.upperField.setName(UPPER_LABEL);
        this.lowerField.setName(LOWER_LABEL);
        this.upperField.setColumns(5);
        this.lowerField.setColumns(5);
        this.upperField.setFocusLostBehavior(3);
        this.lowerField.setFocusLostBehavior(3);
        this.setLayout(new FlowLayout(3, 0, 0));
        this.add(lowerPanel);
        this.add(upperPanel);
    }

    private void addCommittingAction(final JFormattedTextField field) {
        field.getDocument().addDocumentListener((DocumentListener)new SearchGuiField.DocumentListenerAdapter(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    field.commitEdit();
                }
                catch (ParseException ex) {
                    OrderMate.LOG.warn("Couldn't parse price:", (Throwable)ex);
                }
            }
        }));
    }

    public void addAction(Action newAction) {
        if (newAction != null) {
            this.action = newAction;
            this.upperField.getDocument().addDocumentListener((DocumentListener)new SearchGuiField.DocumentListenerAdapter((ActionListener)this.action));
            this.lowerField.getDocument().addDocumentListener((DocumentListener)new SearchGuiField.DocumentListenerAdapter((ActionListener)this.action));
        }
    }

    public void setLowerValue(Number value) {
        this.lowerField.setValue(value);
    }

    public void setUpperValue(Number value) {
        this.upperField.setValue(value);
    }

    public void setNumericalBounds(Number lowerValue, Number upperValue) {
        this.setLowerValue(lowerValue);
        this.setUpperValue(upperValue);
    }

    public Integer getUpperValue() {
        Object value = this.upperField.getValue();
        if (value != null) {
            value = ((Number)value).intValue();
        }
        return (Integer)value;
    }

    public Integer getLowerValue() {
        Object value = this.lowerField.getValue();
        if (value != null) {
            value = ((Number)value).intValue();
        }
        return (Integer)value;
    }

    public boolean valuesMatch() {
        Integer lower = (Integer)this.lowerField.getValue();
        Integer upper = (Integer)this.upperField.getValue();
        if (lower == null) {
            return upper == null;
        }
        return lower.equals(upper);
    }
}

