/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.controls.toolbar;

import au.com.ordermate.gui.actions.BasicAction;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.adminkit.fieldpanels.ArrayFieldPanel;
import officemate.components.controls.toolbar.CrudService;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.StandardSecurityDecorator;

public class CrudToolBar {
    public static final String DELETE_ALL_ICON_PATH = "/ordermate/images/deleteall_icon22.png";
    public static final String DELETE_ICON_PATH = "/ordermate/images/delete_icon22.png";
    public static final String EDIT_ICON_PATH = "/ordermate/images/edit_icon22.png";
    public static final String ADD_ICON_PATH = "/ordermate/images/new_icon22.png";
    private static final ImageIcon ADD_ICON = new ImageIcon(ArrayFieldPanel.class.getResource("/ordermate/images/new_icon22.png"));
    private static final ImageIcon EDIT_ICON = new ImageIcon(ArrayFieldPanel.class.getResource("/ordermate/images/edit_icon22.png"));
    private static final ImageIcon REMOVE_ICON = new ImageIcon(ArrayFieldPanel.class.getResource("/ordermate/images/delete_icon22.png"));
    private static final ImageIcon REMOVE_ALL_ICON = new ImageIcon(ArrayFieldPanel.class.getResource("/ordermate/images/deleteall_icon22.png"));
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private StandardSecurityDecorator addDecorator;
    private StandardSecurityDecorator editDecorator;
    private StandardSecurityDecorator removeDecorator;
    private StandardSecurityDecorator removeAllDecorator;
    private CrudService crudService;
    private JPanel toolbarPanel = new JPanel();

    public CrudToolBar() {
        this(null);
    }

    public CrudToolBar(CrudService service) {
        this.crudService = service;
        this.addButton = new JButton((Action)new BasicAction("Add", ADD_ICON, "Add"){

            public void actionPerformed(ActionEvent e) {
                if (CrudToolBar.this.toolbarPanel.isEnabled()) {
                    CrudToolBar.this.crudService.newElement();
                }
            }
        });
        this.editButton = new JButton((Action)new BasicAction("Edit", EDIT_ICON, "Edit"){

            public void actionPerformed(ActionEvent e) {
                if (CrudToolBar.this.toolbarPanel.isEnabled()) {
                    CrudToolBar.this.crudService.editSelectedElement();
                }
            }
        });
        this.removeButton = new JButton((Action)new BasicAction("Remove", REMOVE_ICON, "Remove"){

            public void actionPerformed(ActionEvent e) {
                if (CrudToolBar.this.toolbarPanel.isEnabled()) {
                    CrudToolBar.this.crudService.removeSelectedElement();
                }
            }
        });
        this.removeAllButton = new JButton((Action)new BasicAction("Remove All", REMOVE_ALL_ICON, "Remove All"){

            public void actionPerformed(ActionEvent e) {
                if (CrudToolBar.this.toolbarPanel.isEnabled()) {
                    CrudToolBar.this.crudService.removeAllElements();
                }
            }
        });
        this.toolbarPanel.setLayout(new GridLayout(1, 4));
        this.configureButton(this.addButton);
        this.configureButton(this.editButton);
        this.configureButton(this.removeButton);
        this.configureButton(this.removeAllButton);
        this.addDecorator = new StandardSecurityDecorator((JComponent)this.addButton, null);
        this.editDecorator = new StandardSecurityDecorator((JComponent)this.editButton, null);
        this.removeDecorator = new StandardSecurityDecorator((JComponent)this.removeButton, null);
        this.removeAllDecorator = new StandardSecurityDecorator((JComponent)this.removeAllButton, null);
        this.toolbarPanel.add((Component)this.addDecorator);
        this.toolbarPanel.add((Component)this.editDecorator);
        this.toolbarPanel.add((Component)this.removeDecorator);
        this.toolbarPanel.add((Component)this.removeAllDecorator);
    }

    private void configureButton(JButton button) {
        button.setFocusable(false);
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
    }

    public void setCrudService(CrudService service) {
        this.crudService = service;
    }

    public JComponent getGuiComponent() {
        return this.toolbarPanel;
    }

    public void setAddEnabled(boolean enabled) {
        this.addDecorator.setEnabled(enabled);
    }

    public void setEditEnabled(boolean enabled) {
        this.editDecorator.setEnabled(enabled);
    }

    public void setRemoveEnabled(boolean enabled) {
        this.removeDecorator.setEnabled(enabled);
    }

    public void setRemoveAllEnabled(boolean enabled) {
        this.removeAllDecorator.setEnabled(enabled);
    }

    public void removeEditButton() {
        this.toolbarPanel.remove(this.editButton);
        this.editButton.setEnabled(false);
    }

    public Action getAddAction() {
        return this.addDecorator.createAction();
    }

    public Action getEditAction() {
        return this.editDecorator.createAction();
    }

    public Action getRemoveAction() {
        return this.removeDecorator.createAction();
    }

    public Action getRemoveAllAction() {
        return this.removeAllDecorator.createAction();
    }

    public void addActionListenerToAll(ActionListener al) {
        this.addButton.addActionListener(al);
        this.editButton.addActionListener(al);
        this.removeAllButton.addActionListener(al);
        this.removeButton.addActionListener(al);
    }

    public void setPermission(Permission value) {
        this.addDecorator.setPermission(value);
        this.editDecorator.setPermission(value);
        this.removeDecorator.setPermission(value);
        this.removeAllDecorator.setPermission(value);
    }
}

