/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.internationalization;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.database.misc.BusinessInfo;
import ordermate.internationalization.updates.InternationalizationUpdater;

public class RegionChangerComboBox
extends JComboBox {
    InternationalizationUpdater updater;

    public RegionChangerComboBox() {
        try {
            this.updater = new InternationalizationUpdater();
            this.refreshComboBox();
            this.addActionListener(new UpdateListener());
        }
        catch (Exception e) {
            OfficeMate.LOG.error("Could not instantiate Internationalization classes", (Throwable)e);
        }
    }

    private void refreshComboBox() {
        this.removeAllItems();
        if (this.updater != null) {
            for (String item : this.updater.getNames()) {
                this.addItem(item);
            }
        } else {
            this.addItem("Updater setup is broken. Check the logs!");
        }
        this.setSelectedItem(BusinessInfo.getInstance().getCountry());
    }

    public void showDialog() {
        this.setFocusable(false);
        if (Dialogs.showChoiceDialog("Warning", "This will affect your internationalization settings.\nAre you sure you want to change your internationalization settings?")) {
            String resultMessage = this.changeRegionRelatedInformation();
            Dialogs.showInfoDialog("Results:", resultMessage);
        }
        this.setFocusable(true);
        this.refreshComboBox();
    }

    private String changeRegionRelatedInformation() {
        String resultMessage = "";
        resultMessage = this.updater != null ? this.updater.runUpdateMethods(this.getSelectedItem().toString()) : "Fatal error, cannot complete internationalization update.";
        return resultMessage;
    }

    private class UpdateListener
    implements ActionListener {
        private UpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RegionChangerComboBox.this.showDialog();
        }
    }
}

