/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.renderers;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import java.awt.Component;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.tree.TreeNode;

public class TreeNodeCheckBoxListCellRenderer
extends JCheckBoxCellRenderer {
    private static final int INDENT_DEPTH = 10;

    public TreeNodeCheckBoxListCellRenderer(String newNoneText) {
        super(newNoneText);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        TreeNode group;
        JComponent component = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value == null) {
            return component;
        }
        if (value instanceof TreeNode && (group = (TreeNode)value).getParent() != null) {
            JComponent superComponent = component;
            component = new Box(0);
            int depth = this.calcDepth(group);
            component.add(Box.createHorizontalStrut(10 * depth));
            component.add((Component)superComponent, "Center");
        }
        return component;
    }

    protected int calcDepth(TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot calculate depth of null node");
        }
        int count = 0;
        while (node.getParent() != null) {
            ++count;
            node = node.getParent();
        }
        return count;
    }

    protected void addSelectedElement(Object obj) {
        super.addSelectedElement(obj);
        if (obj instanceof TreeNode) {
            Enumeration<? extends TreeNode> children = ((TreeNode)obj).children();
            while (children.hasMoreElements()) {
                this.addSelectedElement(children.nextElement());
            }
        }
    }

    protected void removeSelectedElement(Object obj) {
        LinkedHashSet selectedElements = this.getSelectedElements();
        selectedElements.remove(obj);
        this.setSelectedElements(selectedElements);
        if (obj instanceof TreeNode) {
            Enumeration<? extends TreeNode> children = ((TreeNode)obj).children();
            while (children.hasMoreElements()) {
                this.removeSelectedElement(children.nextElement());
            }
        }
    }
}

