/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.configuration.Config;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.OfficeMate;
import officemate.components.OfficeMateObjectSearch;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;

public abstract class AbstractObjectSearch<T>
implements OfficeMateObjectSearch<T> {
    public static final int PAGE_SIZE = 100;
    private final EventList<T> objectList;
    private JPanel searchPanel;
    private static Future refreshTask;
    private static final ExecutorService service;
    private boolean systemStateFilterActive = false;
    private Set<SystemState> filterSystemStateSet;

    protected abstract JPanel createSearchPanel();

    public AbstractObjectSearch(EventList<T> eventObjectList) {
        this.objectList = eventObjectList;
        this.filterSystemStateSet = new HashSet<SystemState>();
        this.filterSystemStateSet.add(SystemState.ACTIVE_STATE);
    }

    @Override
    public final JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = this.createSearchPanel();
        }
        return this.searchPanel;
    }

    @Override
    public EventList<T> getObjectList() {
        return this.objectList;
    }

    public void refresh() {
        if (!(OfficeMate.isStartingUp() && Config.isConfigSetup() && Config.getBooleanValue((String)"ignore_reports_on_startup"))) {
            this.refresh(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh(final Runnable postRefreshEDTCallBack) {
        ExecutorService executorService = service;
        synchronized (executorService) {
            if (refreshTask != null) {
                refreshTask.cancel(true);
            }
            refreshTask = service.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.yield();
                    try {
                        AbstractObjectSearch.this.doRefresh();
                        if (postRefreshEDTCallBack != null && !Thread.interrupted()) {
                            SwingUtilities.invokeLater(postRefreshEDTCallBack);
                        }
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Error adding Search Property:", (Throwable)new RuntimeException(ex));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRefresh() {
        ExecutorService executorService = service;
        synchronized (executorService) {
            if (refreshTask != null && !refreshTask.isCancelled() && !refreshTask.isDone()) {
                OrderMate.LOG.info("Refresh cancelled in abstractObjectSearch");
                refreshTask.cancel(true);
            }
        }
    }

    protected abstract void doRefresh();

    protected final void clearObjectList() {
        try {
            this.objectList.getReadWriteLock().writeLock().lock();
            this.objectList.clear();
        }
        catch (Exception e) {
            OrderMate.LOG.warn("error clearing object list", (Throwable)e);
        }
        finally {
            this.objectList.getReadWriteLock().writeLock().unlock();
        }
    }

    protected void copyIntoObjectList(Collection<T> toCopy) {
        if (Thread.interrupted()) {
            return;
        }
        if (toCopy.size() <= 100) {
            ArrayList<T> copy = new ArrayList<T>(toCopy);
            this.directCopyIntoObjectList(copy);
            return;
        }
        ArrayList<T> addList = new ArrayList<T>(100);
        Iterator<T> it = toCopy.iterator();
        while (it.hasNext()) {
            addList.add(it.next());
            if (addList.size() != 100 && it.hasNext()) continue;
            this.directCopyIntoObjectList(addList);
            addList = new ArrayList(100);
        }
    }

    private void directCopyIntoObjectList(Collection<T> toCopy) {
        try {
            this.objectList.getReadWriteLock().writeLock().lock();
            this.objectList.addAll(toCopy);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Error clearing object list", (Throwable)e);
        }
        finally {
            this.objectList.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void setSystemStateFilterActive(boolean newFilterActive) {
        this.systemStateFilterActive = newFilterActive;
    }

    @Override
    public boolean isSystemStateFilterActive() {
        return this.systemStateFilterActive;
    }

    protected Set<SystemState> getFilterSystemStateSet() {
        return this.filterSystemStateSet;
    }

    protected void setFilterSystemStateSet(Set<SystemState> newFilterSystemStateSet) {
        this.filterSystemStateSet.clear();
        this.filterSystemStateSet.addAll(newFilterSystemStateSet);
    }

    public boolean addFilterSystemState(SystemState sysState) {
        return this.filterSystemStateSet.add(sysState);
    }

    static {
        service = Executors.newSingleThreadExecutor();
    }

    public class RefreshActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractObjectSearch.this.refresh();
        }
    }
}

