/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import org.jdesktop.swingx.JXHeader;

public abstract class AbstractSearchDialog<T> {
    static final int MIN_WIDTH = 550;
    protected OfficeMateObjectSearch searchState;
    protected JDialog searchDialog;
    protected boolean okClicked = false;
    protected PersistentObjectTable<T> objectTable;
    protected String typeName;
    private final ImageIcon dialogIcon;

    public AbstractSearchDialog(OfficeMateObjectSearch<T> state, ColumnTableFormat tableFormat, String newTypeName, ImageIcon icon) {
        this.searchState = state;
        this.typeName = newTypeName;
        this.objectTable = new PersistentObjectTable<T>(state.getObjectList(), tableFormat);
        this.objectTable.getTable().setVisibleRowCount(10);
        this.dialogIcon = icon == null ? IconLoader.get((String)"/ordermate/images/ordermate_icon.png") : icon;
        this.searchDialog = this.createSearchDialog();
    }

    public final PersistentObjectTable<T> getObjectTable() {
        return this.objectTable;
    }

    public JDialog getDialog() {
        return this.searchDialog;
    }

    public Object doDialog(Container appFrame) {
        this.searchState.resetSearch();
        this.okClicked = false;
        this.searchDialog.setLocationRelativeTo(appFrame);
        this.searchDialog.setVisible(true);
        this.searchState.resetSearch();
        return this.doDialogGetResult();
    }

    protected abstract Object doDialogGetResult();

    public boolean wasCancelled() {
        return !this.okClicked;
    }

    protected JDialog createSearchDialog() {
        JDialog newSearchDialog = new JDialog();
        newSearchDialog.setLayout(new BorderLayout());
        newSearchDialog.setModal(true);
        newSearchDialog.setIconImage(this.dialogIcon.getImage());
        this.addResetFocusWhenWindowActivatedListener(newSearchDialog);
        JPanel centre = this.addCentre(newSearchDialog);
        JXHeader header = new JXHeader("Find " + this.typeName, "You can use this screen to find a " + this.typeName, (Icon)IconLoader.get((String)"/ordermate/images/search22.png"));
        Box box = this.createHeader(header);
        newSearchDialog.add((Component)box, "North");
        JPanel southPanel = this.createButtonBar(this.createOkCancelClearButtons(newSearchDialog));
        newSearchDialog.add((Component)southPanel, "South");
        int height = header.getHeight() + centre.getHeight() + southPanel.getHeight();
        newSearchDialog.setMinimumSize(new Dimension(550, height));
        newSearchDialog.pack();
        return newSearchDialog;
    }

    private Box createHeader(JXHeader header) {
        Box box = new Box(1);
        box.add((Component)header);
        box.add(new JSeparator());
        return box;
    }

    protected JPanel addCentre(JDialog newSearchDialog) {
        JPanel centre = new JPanel(new BorderLayout());
        centre.add((Component)this.searchState.getSearchPanel(), "North");
        centre.add(this.objectTable, this.getObjectTableBorderLayout());
        this.addPeripheralPanel(centre);
        centre.validate();
        newSearchDialog.add((Component)centre, "Center");
        return centre;
    }

    protected abstract Component addPeripheralPanel(JPanel var1);

    protected abstract String getObjectTableBorderLayout();

    protected JPanel createButtonBar(JButton[] buttons) {
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton[])buttons);
        buttonBar.setBorder(Borders.DIALOG_BORDER);
        return buttonBar;
    }

    protected JButton[] createOkCancelClearButtons(JDialog newSearchDialog) {
        BasicAction okAction = new BasicAction("Ok"){

            public void actionPerformed(ActionEvent e) {
                AbstractSearchDialog.this.searchDialog.setVisible(false);
                AbstractSearchDialog.this.okClicked = true;
            }
        };
        JButton okButton = new JButton((Action)okAction);
        newSearchDialog.getRootPane().setDefaultButton(okButton);
        BasicAction cancelAction = new BasicAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                AbstractSearchDialog.this.searchDialog.setVisible(false);
                AbstractSearchDialog.this.okClicked = false;
            }
        };
        JButton cancelButton = new JButton((Action)cancelAction);
        newSearchDialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), cancelAction.getText());
        newSearchDialog.getRootPane().getActionMap().put(cancelAction.getText(), (Action)cancelAction);
        BasicAction clearAction = new BasicAction("Clear Search"){

            public void actionPerformed(ActionEvent e) {
                AbstractSearchDialog.this.searchState.resetSearch();
                AbstractSearchDialog.this.objectTable.getTable().clearSelection();
            }
        };
        JButton clearButton = new JButton((Action)clearAction);
        JButton[] buttons = new JButton[]{okButton, cancelButton, clearButton};
        return buttons;
    }

    private void addResetFocusWhenWindowActivatedListener(JDialog newSearchDialog) {
        newSearchDialog.addWindowListener(new WindowAdapter(){

            private final void resetFocus() {
                AbstractSearchDialog.this.searchDialog.getFocusTraversalPolicy().getDefaultComponent(AbstractSearchDialog.this.searchDialog).requestFocusInWindow();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                this.resetFocus();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                this.resetFocus();
            }
        });
    }
}

