/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.SearchGuiCheckboxDecorator;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import ordermate.gui.FieldPanelBuilder;

public class AdvancedSearchComponent {
    private AdvancedSearchPanel advancedPanel;
    private JPanel buttonPanel;
    private RefreshAction refresh;
    private ObjectQuerySearcher searcher;

    public AdvancedSearchComponent(ObjectQuerySearcher newSearcher) {
        this.searcher = newSearcher;
        this.createAdvanceSearchButtonPanel();
    }

    public void setRefreshAction(RefreshAction newRefresh) {
        this.refresh = newRefresh;
    }

    public void addSearchFieldToAdvanced(SearchGuiField newField) {
        this.advancedPanel = this.getAdvancedSearchPanel();
        this.advancedPanel.addGuiSearchField(newField.getLabel(), newField);
    }

    public void addSearchFieldToAdvanced(String fieldLabel, SearchGuiField newField) {
        this.advancedPanel = this.getAdvancedSearchPanel();
        this.advancedPanel.addGuiSearchField(fieldLabel, newField);
    }

    private void createAdvanceSearchButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        EmptyBorder newBorder = new EmptyBorder(5, 5, 5, 5);
        this.buttonPanel.setBorder(newBorder);
        JButton button = new JButton();
        button.setName("Advanced");
        button.setText("Advanced...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSearchComponent.this.advancedSearchDialog(e);
            }
        });
        this.buttonPanel.add(button);
    }

    private void advancedSearchDialog(ActionEvent e) {
        this.advancedPanel = this.getAdvancedSearchPanel();
        OkCancelDialogBuilder advDialogBuilder = new OkCancelDialogBuilder(this.advancedPanel);
        advDialogBuilder.hideCancel().setTitle("Advanced Customer Search").doPack();
        if (advDialogBuilder.doShow()) {
            this.advancedPanel.advancedOkPressed();
            this.refresh.actionPerformed(e);
        }
    }

    public void clearAllSearches(ActionEvent e) {
        this.advancedPanel.uncheckAll();
        this.refresh.actionPerformed(e);
    }

    public AdvancedSearchPanel getAdvancedSearchPanel() {
        if (this.advancedPanel == null) {
            return new AdvancedSearchPanel(this.searcher);
        }
        return this.advancedPanel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public BasicAction getAction(String label, String icon, String tooltip) {
        return new BasicAction(label, IconLoader.get((String)icon), tooltip){

            public void actionPerformed(ActionEvent e) {
                AdvancedSearchComponent.this.advancedSearchDialog(e);
            }
        };
    }

    public class AdvancedSearchPanel
    extends JPanel {
        private ObjectQuerySearcher searcher;
        List<SearchGuiCheckboxDecorator> searchTypes;
        FieldPanelBuilder builder;
        JButton reset;

        public AdvancedSearchPanel(ObjectQuerySearcher searcher) {
            super(new BorderLayout());
            this.searcher = searcher;
            this.searchTypes = new ArrayList<SearchGuiCheckboxDecorator>();
            this.builder = new FieldPanelBuilder();
            this.reset = new JButton();
            this.reset.setName("Reset Search");
            this.reset.setText("Reset Search");
            this.reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdvancedSearchPanel.this.uncheckAll();
                }
            });
        }

        public void addGuiSearchField(String fieldLabel, SearchGuiField newField) {
            SearchGuiCheckboxDecorator newCustomerCheckedDateRange = new SearchGuiCheckboxDecorator(fieldLabel, null, newField);
            this.searchTypes.add(newCustomerCheckedDateRange);
            this.builder.addRow(newCustomerCheckedDateRange.getLabel(), newCustomerCheckedDateRange.getGuiComponent());
            this.removeAll();
            this.add((Component)this.builder.getPanel(), "Center");
            JPanel buttonOffset = new JPanel(new BorderLayout());
            buttonOffset.add((Component)this.reset, "West");
            this.add((Component)buttonOffset, "South");
        }

        public void advancedOkPressed() {
            for (SearchGuiCheckboxDecorator obj : this.searchTypes) {
                if (!obj.isEnabled()) {
                    obj.getSearchProperty().clearSearch();
                }
                this.searcher.addSearchFilter(obj.getSearchProperty());
            }
        }

        public void uncheckAll() {
            for (SearchGuiCheckboxDecorator obj : this.searchTypes) {
                if (obj.isEnabled()) {
                    obj.getCheckBox().setSelected(false);
                    obj.setEnabled(false);
                    obj.getSearchProperty().clearSearch();
                }
                this.searcher.addSearchFilter(obj.getSearchProperty());
            }
        }
    }
}

