/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.NumberSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.renderers.TreeNodeCheckBoxListCellRenderer;
import officemate.components.renderers.TreeNodeListCellRenderer;
import officemate.components.search.AdvancedSearchComponent;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.config.CustomerGroup;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.ConfigShift;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.searchers.reports.ItemSearcher;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportSearcher;
import ordermate.database.searchers.reports.sales.general.itemunsold.ItemUnsoldReportSearcher;
import ordermate.database.users.User;

public class ItemPropertySearch<T extends PersistentObjectI>
extends ObjectPropertySearch<T> {
    private final EventList<InventoryGroup> menuSections = GlazedLists.eventList((Collection)InventoryGroupQueries.getAllGroups());
    private final EventList<Terminal> terminals = GlazedLists.eventList((Collection)Terminal.getAllTerminalsExceptServer());
    private final EventList<User> users = GlazedLists.eventList((Collection)User.getUsers());
    private final EventList<CustomerCategory> customercategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
    private final EventList<InventoryCategory> categories = GlazedLists.eventList((Collection)InventoryCategory.getAllCategories());
    private final EventList<CustomerGroup> customergroups = GlazedLists.eventList((Collection)CustomerGroup.getAllCustomerGroups());
    private final EventList<InventoryItemSize> sizes = new BasicEventList();
    private final EventList<PriceLevel> priceLevels = new BasicEventList();
    private final List<ConfigShift> configShifts = ConfigShift.getAllConfigShifts();
    private final EventList<SalesLocation> salesLocations = new BasicEventList();
    private AdvancedSearchComponent advancedPanel;

    public ItemPropertySearch(Class<T> objClassToSearch, ObjectQuerySearcher<T> newSearcher, EventList<T> eventObjectList) {
        super(objClassToSearch, newSearcher, eventObjectList);
    }

    public ItemPropertySearch(Class<T> objClassToSearch, EventList<T> eventObjectList) {
        super(objClassToSearch, eventObjectList);
    }

    @Override
    public void reaquireSearchOptions() {
        super.reaquireSearchOptions();
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.menuSections, InventoryGroupQueries.getAllGroups());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.terminals, Terminal.getAllTerminalsExceptServer());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.users, User.getUsers());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.customercategories, CustomerCategory.getAllCategories());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.categories, InventoryCategory.getAllCategories());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.customergroups, CustomerGroup.getAllCustomerGroups());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.sizes, InventoryItemSize.getAllSizes());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.priceLevels, PriceLevel.getAllPriceLevels());
        OfficeMateAdminGuiUtils.getInstance();
        OfficeMateAdminGuiUtils.updateList(this.salesLocations, SalesLocation.getSalesLocations());
    }

    public JPanel itemSoldSearchSetup(ItemSoldReportSearcher searcher, Action refreshAction) {
        this.addSearchField((SearchGuiField)new StringSearchField("Item Name", searcher.getItemNameFilter(), refreshAction));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", refreshAction, GlazedLists.eventList(this.configShifts), null, (MultiOptionSearchFilter)searcher.getShiftFilter(), new JCheckBoxCellRenderer()));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", refreshAction, this.salesLocations, null, searcher.getSalesLocationFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel = new AdvancedSearchComponent((ObjectQuerySearcher)searcher);
        this.advancedPanel.setRefreshAction((RefreshAction)refreshAction);
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Menu Section", null, this.menuSections, null, searcher.getMenuSectionFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Inventory Category", null, this.categories, null, (MultiOptionSearchFilter)searcher.getCategoryFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Size", null, this.sizes, null, searcher.getSizeFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Price Level", null, this.priceLevels, null, searcher.getPriceLevelFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Account type", null, GlazedLists.eventList(AccountType.register.values()), null, searcher.getAccountTypeFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("User", null, this.users, null, searcher.getUserFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Terminal", null, this.terminals, null, searcher.getTerminalFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Customer Category", null, this.customercategories, null, searcher.getCustomerCategoryFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Customer Group", null, this.customergroups, null, searcher.getCustomerGroupFilter(), new JCheckBoxCellRenderer()));
        return this.advancedPanel.getButtonPanel();
    }

    public JPanel itemUnSoldSearchSetup(ItemUnsoldReportSearcher searcher, Action refreshAction) {
        this.addSearchField((SearchGuiField)new StringSearchField("Item Name", searcher.getItemNameFilter(), refreshAction));
        this.addSearchField((SearchGuiField)new NumberSearchField("Quantity Minimum", (ISingleValueSearchFilter)searcher.getQuantityMinimumSearch(), refreshAction, "0"));
        this.addSearchField((SearchGuiField)new NumberSearchField("Quantity Maximum", (ISingleValueSearchFilter)searcher.getQuantityMaximumSearch(), refreshAction, "0"));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", refreshAction, GlazedLists.eventList(this.configShifts), null, (MultiOptionSearchFilter)searcher.getShiftFilter(), new JCheckBoxCellRenderer()));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", refreshAction, this.salesLocations, null, searcher.getSalesLocationFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel = new AdvancedSearchComponent((ObjectQuerySearcher)searcher);
        this.advancedPanel.setRefreshAction((RefreshAction)refreshAction);
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Menu Section", null, this.menuSections, null, searcher.getMenuSectionFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Inventory Category", null, this.categories, null, (MultiOptionSearchFilter)searcher.getCategoryFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Size", null, this.sizes, null, searcher.getSizeFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Price Level", null, this.priceLevels, null, searcher.getPriceLevelFilter(), (JCheckBoxCellRenderer)new TreeNodeCheckBoxListCellRenderer("Any")));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Account type", null, GlazedLists.eventList(AccountType.register.values()), null, searcher.getAccountTypeFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("User", null, this.users, null, searcher.getUserFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Terminal", null, this.terminals, null, searcher.getTerminalFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Customer Category", null, this.customercategories, null, searcher.getCustomerCategoryFilter(), new JCheckBoxCellRenderer()));
        this.advancedPanel.addSearchFieldToAdvanced((SearchGuiField)new MultiSelectComboSearchField("Customer Group", null, this.customergroups, null, searcher.getCustomerGroupFilter(), new JCheckBoxCellRenderer()));
        return this.advancedPanel.getButtonPanel();
    }

    public void comboSoldSearchSetup(ItemSearcher<T> searcher, Action refreshAction) {
        this.addSearchField((SearchGuiField)new ComboSearchField("Menu Section", searcher.getMenuSectionFilter(), true, refreshAction, this.menuSections).setRenderer((ListCellRenderer)new TreeNodeListCellRenderer()));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Terminal", refreshAction, this.terminals, null, searcher.getTerminalFilter(), new JCheckBoxCellRenderer()));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", refreshAction, GlazedLists.eventList(this.configShifts), null, (MultiOptionSearchFilter)searcher.getShiftFilter(), new JCheckBoxCellRenderer()));
    }
}

