/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.gui.actions.BasicAction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.AbstractSearchDialog;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.inventory.ItemSummary;
import org.jdesktop.swingx.VerticalLayout;

public class MultiItemSearchDialog
extends AbstractSearchDialog {
    JList items;
    EventList<ItemSummary> source;

    public MultiItemSearchDialog(OfficeMateObjectSearch state, ColumnTableFormat tableFormat, String newTypeName, ImageIcon icon) {
        super(state, tableFormat, newTypeName, icon);
    }

    private JPanel createSelectedItemsPanel(JPanel panelToAdd) {
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalLayout());
        buttonsPanel.add(this.createAddButton());
        buttonsPanel.add(this.createRemoveButton());
        buttonsPanel.add(this.createRemoveAllButton());
        buttonsPanel.setMinimumSize(new Dimension(110, 100));
        buttonsPanel.setPreferredSize(new Dimension(137, 100));
        buttonsPanel.setMaximumSize(new Dimension(183, 100));
        panelToAdd.add((Component)buttonsPanel, "Center");
        this.source = new BasicEventList();
        EventListModel dataModel = new EventListModel(this.source);
        this.items = new JList(dataModel);
        Dimension preferredSize = new Dimension(183, 100);
        this.items.setMinimumSize(preferredSize);
        this.items.setCellRenderer(new InventoryItemUnitRenderer());
        JScrollPane scrollPane = new JScrollPane(this.items);
        scrollPane.setBorder(new TitledBorder("Selected Items"));
        panelToAdd.add((Component)scrollPane, "East");
        return panelToAdd;
    }

    @Override
    public Object doDialogGetResult() {
        if (this.okClicked) {
            return this.source;
        }
        return null;
    }

    private JButton createAddButton() {
        BasicAction addAction = new BasicAction("Add"){

            public void actionPerformed(ActionEvent e) {
                if (MultiItemSearchDialog.this.objectTable.hasSelectedObject()) {
                    MultiItemSearchDialog.this.source.addAll(MultiItemSearchDialog.this.objectTable.getAllSelectedObjects());
                }
            }
        };
        return new JButton((Action)addAction);
    }

    private JButton createRemoveButton() {
        BasicAction removeAction = new BasicAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                if (!MultiItemSearchDialog.this.items.isSelectionEmpty()) {
                    MultiItemSearchDialog.this.source.removeAll(Arrays.asList(MultiItemSearchDialog.this.items.getSelectedValues()));
                }
            }
        };
        return new JButton((Action)removeAction);
    }

    private JButton createRemoveAllButton() {
        BasicAction removeAll = new BasicAction("Remove All"){

            public void actionPerformed(ActionEvent e) {
                MultiItemSearchDialog.this.source.clear();
            }
        };
        return new JButton((Action)removeAll);
    }

    @Override
    protected Component addPeripheralPanel(JPanel toAdd) {
        return this.createSelectedItemsPanel(toAdd);
    }

    @Override
    protected String getObjectTableBorderLayout() {
        return "West";
    }

    private class InventoryItemUnitRenderer
    implements ListCellRenderer {
        private InventoryItemUnitRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            if (value instanceof ItemSummary) {
                ItemSummary itemUnit = (ItemSummary)value;
                String text = itemUnit.getName() + " (" + itemUnit.getSize() + ", " + itemUnit.getPortion() + ")";
                label.setText(text);
                if (isSelected) {
                    label.setBackground(list.getSelectionBackground());
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setBackground(list.getBackground());
                    label.setForeground(list.getForeground());
                }
            } else {
                label.setText(value.toString());
            }
            return label;
        }
    }
}

