/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.DateRangePanel;
import au.com.ordermate.search.filter.EventListFilter;
import au.com.ordermate.search.pager.Pageable;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.controls.ComboDateRangePanel;
import officemate.components.search.AbstractObjectSearch;
import officemate.components.search.AbstractRefreshStrategy;
import officemate.components.search.SearchBarPanel;
import officemate.components.search.refreshstrategy.LimitObjectQueryStrategy;
import officemate.components.search.refreshstrategy.PageableRefreshStrategy;
import officemate.components.search.refreshstrategy.PagedObjectQueryStrategy;
import officemate.components.search.refreshstrategy.SearcherRefreshStrategy;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.screens.reports.saleshistory.ComboDateRangeSearchField;
import ordermate.OrderMate;

public class ObjectPropertySearch<T extends PersistentObjectI>
extends AbstractObjectSearch<T> {
    private static final int MAX_OBJECT_COUNT = 10000;
    protected SearchBarPanel searchGui;
    private final Class<T> persistentClass;
    protected JPanel customPanel;
    protected final List<SearchGuiField> searchFields = new ArrayList<SearchGuiField>();
    private final List<SearchGuiField> filterFields = new ArrayList<SearchGuiField>();
    protected final List<JComponent> customComps = new ArrayList<JComponent>();
    private CompositeMatcherEditor<T> compositeFilter;
    private FilterList<T> filteredList;
    private ObjectQuerySearcher<T> searcher;
    private static ExecutorService databaseAccessService = Executors.newCachedThreadPool();
    private AbstractRefreshStrategy refreshStrategy;
    private Calendar currentStartTradingDayTime;
    private Calendar currentEndTradingDayTime;
    private Date currentStartTime;
    private Date currentEndTime;
    private boolean wasOnOpenTradingDay;

    public ObjectPropertySearch(Class<T> objClassToSearch) {
        this(objClassToSearch, (EventList<T>)new BasicEventList());
    }

    public ObjectPropertySearch(Class<T> objClassToSearch, EventList<T> eventObjectList) {
        super(eventObjectList);
        this.persistentClass = objClassToSearch;
        this.filteredList = new FilterList(super.getObjectList());
        this.customPanel = new JPanel();
        this.customPanel.setLayout(new BoxLayout(this.customPanel, 0));
        this.customPanel.setEnabled(false);
        this.refreshStrategy = new LimitObjectQueryStrategy(this, 100);
    }

    public ObjectPropertySearch(Class<T> objClassToSearch, ObjectQuerySearcher<T> newSearcher, EventList<T> eventObjectList) {
        this(objClassToSearch, eventObjectList);
        this.searcher = newSearcher;
    }

    List<SearchGuiField> getSearchFields() {
        return this.searchFields;
    }

    ExecutorService getDatabaseAccessService() {
        return databaseAccessService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSearchField(SearchGuiField field) {
        List<SearchGuiField> list = this.searchFields;
        synchronized (list) {
            if (field.getSearchProperty() instanceof EventListFilter) {
                this.filterFields.add(field);
            } else {
                this.searchFields.add(field);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSearchField(int index, SearchGuiField field) {
        List<SearchGuiField> list = this.searchFields;
        synchronized (list) {
            if (field.getSearchProperty() instanceof EventListFilter) {
                this.filterFields.add(index, field);
            } else {
                this.searchFields.add(index, field);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSearchField(SearchGuiField field) {
        List<SearchGuiField> list = this.searchFields;
        synchronized (list) {
            if (field.getSearchProperty() instanceof EventListFilter) {
                this.filterFields.remove(field);
            } else {
                this.searchFields.remove(field);
            }
        }
    }

    protected void layoutSearchPanel() {
        this.searchGui.clearFieldPanel();
        this.customPanel.removeAll();
        this.addSearchFields();
        this.addFilterFields();
        this.addCustomFields();
        this.searchGui.refreshLayout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSearchFields() {
        List<SearchGuiField> list = this.searchFields;
        synchronized (list) {
            Iterator<SearchGuiField> iterator = this.searchFields.iterator();
            while (iterator.hasNext()) {
                SearchGuiField element;
                SearchGuiField field = element = iterator.next();
                this.addToSearchGui(this.searchGui, field);
            }
        }
    }

    protected void addFilterFields() {
        if (this.filterFields.size() > 0) {
            this.compositeFilter = new CompositeMatcherEditor();
            this.compositeFilter.setMode(42);
            for (SearchGuiField field : this.filterFields) {
                this.searchGui.addSearchField(field.getLabel(), field.getGuiComponent());
                EventListFilter eventlistFilter = (EventListFilter)field.getSearchProperty();
                eventlistFilter.addMatcherEditor(this.compositeFilter);
            }
            this.filteredList.setMatcherEditor(this.compositeFilter);
        }
    }

    protected void addCustomFields() {
        if (!this.customComps.isEmpty()) {
            this.customPanel.setEnabled(true);
            for (JComponent custComp : this.customComps) {
                this.customPanel.add(custComp);
            }
        }
    }

    protected void addToSearchGui(SearchBarPanel searchGui, SearchGuiField field) {
        if (field instanceof DateRangeSearchField) {
            DateRangePanel panel = ((DateRangeSearchField)field).getDateRangePanel();
            searchGui.addSearchField("Start Date:", (Component)panel.getStartPicker());
            searchGui.addSearchField("End Date:", (Component)panel.getEndPicker());
        } else if (field instanceof ComboDateRangeSearchField) {
            ComboDateRangePanel comboField = (ComboDateRangePanel)field.getGuiComponent();
            searchGui.addSearchField("Start " + comboField.getUnitString() + ":", comboField.getStartSearchField().getGuiComponent());
            searchGui.addSearchField("End " + comboField.getUnitString() + ":", comboField.getEndSearchField().getGuiComponent());
        } else {
            searchGui.addSearchField(field);
        }
    }

    @Override
    public JPanel createSearchPanel() {
        this.searchGui = new SearchBarPanel();
        this.searchGui.add((Component)this.customPanel, "East");
        this.layoutSearchPanel();
        return this.searchGui;
    }

    public CompositeMatcherEditor getEventListFilter() {
        return this.compositeFilter;
    }

    protected List<SearchGuiField> getEventListGuiFields() {
        return Collections.unmodifiableList(this.filterFields);
    }

    @Override
    public FilterList<T> getObjectList() {
        return this.filteredList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectQuerySearcher<T> getPropertySearcher() {
        if (this.searcher == null) {
            this.searcher = this.constructPropertySearcher();
        }
        if (!OfficeMate.isStartingUp()) {
            List<SearchGuiField> list = this.searchFields;
            synchronized (list) {
                for (SearchGuiField element : this.searchFields) {
                    SearchGuiField searchField = element;
                    if (!searchField.getGuiComponent().isEnabled()) continue;
                    searchField.getSearchProperty();
                }
            }
        }
        return this.searcher;
    }

    protected ObjectQuerySearcher<T> constructPropertySearcher() {
        DefaultPropertySearcher newSearcher = new DefaultPropertySearcher(this.persistentClass);
        if (this.isSystemStateFilterActive()) {
            newSearcher.setBaseQuery(newSearcher.getBaseQuery().wherePropertyIn(new PropertiedObject.Property(this.persistentClass, "systemState"), this.getFilterSystemStateSet()));
        }
        return newSearcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSearch() {
        List<SearchGuiField> list = this.searchFields;
        synchronized (list) {
            Iterator<SearchGuiField> iterator = this.searchFields.iterator();
            while (iterator.hasNext()) {
                SearchGuiField element;
                SearchGuiField field = element = iterator.next();
                field.reset();
            }
        }
        this.refresh();
    }

    @Override
    public void doRefresh() {
        if (Thread.interrupted()) {
            return;
        }
        this.clearObjectList();
        this.validateDateTimeFilters();
        this.refreshStrategy.doRefresh();
    }

    protected List<T> resolveObjectQuery(final ObjectQuery query, final Class<T> clazz) {
        Future task = databaseAccessService.submit(new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                return PersistenceManager.getObjectList((Class)clazz, (String)query.toString(), (Object[])new Object[0]);
            }
        });
        try {
            return (List)task.get();
        }
        catch (ExecutionException e) {
            String queryString = null;
            try {
                queryString = query.toString();
            }
            catch (Throwable ex) {
                OrderMate.LOG.warn("Error resolving query for log message " + ex.toString());
            }
            throw new RuntimeException("Error resolving object query in search: " + queryString, e);
        }
        catch (InterruptedException ie) {
            return new ArrayList();
        }
    }

    @Override
    public void reaquireSearchOptions() {
    }

    public void usePageableRefreshStrategy(Pageable pageable, Pager pager) {
        this.validateSearcher();
        this.refreshStrategy = new PageableRefreshStrategy(this, pageable, pager);
    }

    public void usePagedObjectQueryRefreshStrategy(Pager pager) {
        this.validateSearcher();
        this.refreshStrategy = new PagedObjectQueryStrategy(this, pager);
    }

    public void useLimitedObjectQueryRefreshStrategy() {
        this.validateSearcher();
        this.refreshStrategy = new LimitObjectQueryStrategy(this, 100);
    }

    private void validateSearcher() {
        if (this.getPropertySearcher() == null) {
            throw new IllegalArgumentException("Cannot use a strategy in a search that doesn't use a query searcher");
        }
    }

    private void validateDateTimeFilters() {
        DateRangeSearchField dateRangeSearch = null;
        TimeRangeSearchField timeRangeSearch = null;
        for (SearchGuiField field : this.searchFields) {
            if (DateRangeSearchField.class.equals(field.getClass())) {
                dateRangeSearch = (DateRangeSearchField)field;
            }
            if (!TimeRangeSearchField.class.equals(field.getClass())) continue;
            timeRangeSearch = (TimeRangeSearchField)field;
        }
        if (dateRangeSearch != null && timeRangeSearch != null) {
            boolean valuesHaveChanged;
            Date currentTime = new Date();
            currentTime.getTime();
            Calendar startTradingDayTime = DateTimeUtils.toCal((Date)((Date)dateRangeSearch.getSearchProperty().getStart()));
            Calendar endTradingDayTime = DateTimeUtils.toCal((Date)((Date)dateRangeSearch.getSearchProperty().getEnd()));
            Date startTimeRange = timeRangeSearch.getTimeRangePanel().getFromDate();
            Date endTimeRange = timeRangeSearch.getTimeRangePanel().getToDate();
            startTimeRange = DateTimeUtils.combineDateAndTime((Date)startTradingDayTime.getTime(), (Date)startTimeRange);
            if (endTradingDayTime != null) {
                endTimeRange = DateTimeUtils.combineDateAndTime((Date)endTradingDayTime.getTime(), (Date)endTimeRange);
            }
            boolean isOnOpenTradingDay = endTradingDayTime != null ? endTradingDayTime.getTime().after(currentTime) : false;
            boolean startTradingDayOverlap = startTimeRange.before(startTradingDayTime.getTime());
            boolean endTradingDayOverlap = endTradingDayTime != null && endTimeRange.after(endTradingDayTime.getTime()) && DateTimeUtils.timeIsBefore((Date)startTimeRange, (Date)endTradingDayTime.getTime());
            boolean bl = valuesHaveChanged = !startTradingDayTime.equals(this.currentStartTradingDayTime) || endTradingDayTime != null && !endTradingDayTime.equals(this.currentEndTradingDayTime) && !isOnOpenTradingDay || !startTimeRange.equals(this.currentStartTime) || !endTimeRange.equals(this.currentEndTime) || isOnOpenTradingDay != this.wasOnOpenTradingDay;
            if (!timeRangeSearch.getTimeRangePanel().getAllDay() && (startTradingDayOverlap || endTradingDayOverlap) && valuesHaveChanged) {
                final String message = "<html>Your chosen time range or day part overlaps with a change of trading day.<br/>Data before <b>" + DateTimeUtils.getDateTimeFormat().format(startTradingDayTime.getTime()) + "</b> or after <b>" + DateTimeUtils.getDateTimeFormat().format(endTradingDayTime.getTime()) + "</b> will not show in the report.</html>";
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dialogs.showMessageDialog("Trading Day Overlap", message, 2, true, false);
                        }
                    });
                } else {
                    Dialogs.showMessageDialog("Trading Day Overlap", message, 2, true, false);
                }
            }
            this.currentStartTradingDayTime = startTradingDayTime;
            this.currentEndTradingDayTime = endTradingDayTime;
            this.currentStartTime = startTimeRange;
            this.currentEndTime = endTimeRange;
            this.wasOnOpenTradingDay = isOnOpenTradingDay;
        }
    }

    public void useSearchRefreshStrategy() {
        this.refreshStrategy = new SearcherRefreshStrategy(this);
    }

    @Override
    public void addToSearchPanel(JComponent comp) {
        this.customComps.add(comp);
    }

    public AbstractRefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }
}

