/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.components.search.SearchPanelBuilder;

public class SearchBarPanel
extends JPanel {
    private JPanel fieldPanel = new JPanel();
    private LinkedHashMap<String, Component> fieldMap;
    private int cols = 0;
    private int minimumCompSize = 0;
    private int minimumLabelSize = 0;
    private boolean enabled = false;

    public SearchBarPanel() {
        super(new BorderLayout());
        this.addComponentListener(new SearchResizer());
        this.fieldMap = new LinkedHashMap();
        this.add((Component)this.fieldPanel, "Center");
    }

    @Override
    public void setEnabled(final boolean status) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateEnabled(status);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchBarPanel.this.updateEnabled(status);
                }
            });
        }
    }

    private void updateEnabled(boolean value) {
        this.enabled = value;
        for (Component comp : this.fieldMap.values()) {
            comp.setEnabled(value);
        }
        super.setEnabled(value);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void prependSearchField(String fieldName, Component guiComp) {
        LinkedHashMap<String, Component> oldMap = this.fieldMap;
        this.fieldMap = new LinkedHashMap();
        this.addSearchField(fieldName, guiComp);
        this.fieldMap.putAll(oldMap);
    }

    public void addSearchField(SearchGuiField searchField) {
        this.addSearchField(searchField.getLabel(), searchField.getGuiComponent());
    }

    public void insertSearchFieldAfter(String fieldName, Component guiComp, Component toAddAfter) {
        LinkedHashMap<String, Component> oldMap = this.fieldMap;
        this.fieldMap = new LinkedHashMap();
        boolean foundComp = false;
        for (Map.Entry<String, Component> entry : oldMap.entrySet()) {
            Component comp = entry.getValue();
            this.addSearchField(entry.getKey(), comp);
            if (comp != toAddAfter) continue;
            this.addSearchField(fieldName, guiComp);
            foundComp = true;
        }
        if (foundComp) {
            return;
        }
        throw new IllegalArgumentException("Could not find component to add after : " + toAddAfter);
    }

    public void addSearchField(String fieldName, Component guiComp) {
        this.fieldMap.put(fieldName, guiComp);
    }

    public void clearFieldPanel() {
        this.fieldPanel.removeAll();
        this.fieldMap.clear();
    }

    public void setup(int numFieldsAcross) {
        this.remove(this.fieldPanel);
        SearchPanelBuilder builder = new SearchPanelBuilder(numFieldsAcross);
        builder.placeFields(this.fieldMap);
        this.fieldPanel = builder.getPanel();
        this.add((Component)this.fieldPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void refreshLayout() {
        this.refreshLayout(false);
    }

    public void refreshLayout(boolean dontCheck) {
        if (this.minimumCompSize == 0) {
            Component[] components = this.fieldPanel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof JLabel) {
                    if (components[i].getWidth() <= this.minimumCompSize) continue;
                    this.minimumCompSize = components[i].getWidth();
                    continue;
                }
                if (components[i].getWidth() <= this.minimumLabelSize) continue;
                this.minimumLabelSize = components[i].getWidth();
            }
        }
        int numCols = 1;
        if (this.minimumCompSize > 0) {
            numCols = (int)Math.ceil(this.fieldPanel.getWidth() / (this.minimumCompSize + this.minimumLabelSize));
        }
        if (dontCheck || this.cols == 0 || this.cols != numCols) {
            this.cols = numCols == 0 ? 1 : numCols;
            this.setup(this.cols);
        }
    }

    private class SearchResizer
    extends ComponentAdapter {
        private SearchResizer() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            SearchBarPanel.this.refreshLayout();
        }
    }
}

