/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import org.jdesktop.swingx.JXHeader;

public class SearchDialog {
    private static final int MIN_WIDTH = 550;
    private OfficeMateObjectSearch searchState;
    private JDialog searchDialog;
    private boolean okClicked = false;
    private PersistentObjectTable objectTable;
    private String typeName;

    public SearchDialog(OfficeMateObjectSearch state, ColumnTableFormat tableFormat, String newTypeName) {
        this.searchState = state;
        this.typeName = newTypeName;
        this.objectTable = new PersistentObjectTable(state.getObjectList(), tableFormat);
        this.objectTable.getTable().setVisibleRowCount(10);
        this.searchDialog = this.createSearchDialog();
    }

    public Object doDialog(JFrame appFrame) {
        this.searchState.resetSearch();
        this.okClicked = false;
        this.searchDialog.setLocationRelativeTo(appFrame);
        this.searchDialog.setVisible(true);
        if (this.okClicked) {
            return this.objectTable.getSelectedObject();
        }
        return null;
    }

    public boolean wasCancelled() {
        return !this.okClicked;
    }

    protected JDialog createSearchDialog() {
        JDialog newSearchDialog = new JDialog();
        newSearchDialog.setLayout(new BorderLayout());
        newSearchDialog.setModal(true);
        Box box = new Box(1);
        JXHeader header = new JXHeader("Find " + this.typeName, "You can use this screen to find a " + this.typeName, (Icon)IconLoader.get((String)"/ordermate/images/search22.png"));
        box.add((Component)header);
        box.add(new JSeparator());
        newSearchDialog.add((Component)box, "North");
        JPanel centre = new JPanel(new BorderLayout());
        centre.add((Component)this.searchState.getSearchPanel(), "North");
        centre.add((Component)this.objectTable, "Center");
        centre.setSize(this.objectTable.getPreferredSize());
        newSearchDialog.add((Component)centre, "Center");
        newSearchDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                SearchDialog.this.searchDialog.getFocusTraversalPolicy().getDefaultComponent(SearchDialog.this.searchDialog).requestFocusInWindow();
            }
        });
        BasicAction okAction = new BasicAction("Ok"){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.searchDialog.setVisible(false);
                SearchDialog.this.okClicked = true;
            }
        };
        JButton okButton = new JButton((Action)okAction);
        newSearchDialog.getRootPane().setDefaultButton(okButton);
        BasicAction cancelAction = new BasicAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.searchDialog.setVisible(false);
                SearchDialog.this.okClicked = false;
            }
        };
        JButton cancelButton = new JButton((Action)cancelAction);
        BasicAction clearAction = new BasicAction("Clear Search"){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.searchState.resetSearch();
                SearchDialog.this.objectTable.getTable().clearSelection();
            }
        };
        JButton clearButton = new JButton((Action)clearAction);
        newSearchDialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), cancelAction.getText());
        newSearchDialog.getRootPane().getActionMap().put(cancelAction.getText(), (Action)cancelAction);
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)okButton, (JButton)cancelButton, (JButton)clearButton);
        buttonBar.setBorder(Borders.DIALOG_BORDER);
        newSearchDialog.add((Component)buttonBar, "South");
        int height = header.getHeight() + centre.getHeight() + buttonBar.getHeight();
        newSearchDialog.setMinimumSize(new Dimension(550, height));
        newSearchDialog.pack();
        return newSearchDialog;
    }
}

