/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.objectsearch;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.abstracts.AbstractPolyPropertySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.CustomerTenureSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FrequentCustomerSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.NewCustomerSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.CustomerTenureSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.FrequentCustomerSearchField;
import au.com.ordermate.search.searchfield.java.FullTextStringSearchField;
import au.com.ordermate.search.searchfield.java.PolyPropertyComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import javax.swing.Action;
import javax.swing.JComponent;
import officemate.components.search.AdvancedSearchComponent;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerSearcher;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CustomerSearcherGui
extends ObjectPropertySearch<Customer> {
    public static final ColumnTableFormat DEFAULT_TABLE_FORMAT = new ColumnTableFormat(new ColumnFormat[]{new AbstractColumnFormat("Name", String.class){

        public Object resolveColumnValue(Object baseObject) {
            return ((Customer)baseObject).getName();
        }
    }, new PropertyColumnFormat(Customer.Properties.PRIMARY_PHONE_NUMBER), new AbstractColumnFormat("Address", String.class){

        public Object resolveColumnValue(Object baseObject) {
            return ((Customer)baseObject).getAddress();
        }
    }});
    private final PropertiedObject.Property[] PROP_TO_ADD_TO_INCOMPLETE;
    private AdvancedSearchComponent advancedPanel;
    private RefreshAction refresh;

    public CustomerSearcherGui(EventList customerCategories, RefreshAction refreshArg, boolean showButtonPanel) {
        super(Customer.class, new CustomerSearcher(), new BasicEventList());
        this.PROP_TO_ADD_TO_INCOMPLETE = new PropertiedObject.Property[]{Customer.Properties.FIRST_NAME, Customer.Properties.LAST_NAME, Customer.Properties.PRIMARY_PHONE_NUMBER, Customer.Properties.SECONDARY_PHONE_NUMBER, Customer.Properties.ROOM_APT_NUMBER, Customer.Properties.HOUSE_NUMBER, Customer.Properties.STREET_NAME, Customer.Properties.STREET_TYPE, Customer.Properties.SUBURB, Customer.Properties.STATE, Customer.Properties.POSTCODE, Customer.Properties.E_MAIL, Customer.Properties.COMMENTS};
        this.setSystemStateFilterActive(true);
        this.refresh = refreshArg == null ? new RefreshAction((Refreshable)this) : refreshArg;
        this.addSearchField((SearchGuiField)new FullTextStringSearchField("Name:", ((CustomerSearcher)this.getSearcher()).getNameSearchFilter(), (Action)this.refresh));
        this.addSearchField((SearchGuiField)new StringSearchField("Phone:", (ISingleValueSearchFilter)((CustomerSearcher)this.getSearcher()).getPhoneSearchFilter(), (Action)this.refresh));
        this.addSearchField((SearchGuiField)new FullTextStringSearchField("Address:", ((CustomerSearcher)this.getSearcher()).getAddressSearchFilter(), (Action)this.refresh));
        if (customerCategories != null && customerCategories.size() > 0) {
            this.addSearchField((SearchGuiField)new ComboSearchField("Category:", (ISingleValueSearchFilter)((CustomerSearcher)this.getSearcher()).getCustomerCategoryFilter(), true, (Action)this.refresh, customerCategories));
        }
        this.advancedPanel = new AdvancedSearchComponent(this.getSearcher());
        this.advancedPanel.setRefreshAction(this.refresh);
        this.advancedPanel.addSearchFieldToAdvanced("New Customers:", (SearchGuiField)new DateRangeSearchField("Date", (IRangedQuerySearchFilter)((CustomerSearcher)this.getSearcher()).getNewCustomerFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), null));
        this.advancedPanel.addSearchFieldToAdvanced("Tenure Greater Than:", (SearchGuiField)new CustomerTenureSearchField("Tenure", ((CustomerSearcher)this.getSearcher()).getCustomerTenureSearchFilter(), null, GlazedLists.eventListOf((Object[])CustomerTenureSearchFilter.UnitOfTime.values())));
        this.advancedPanel.addSearchFieldToAdvanced("Incomplete Fields:", (SearchGuiField)new PolyPropertyComboSearchField("IncompleteCustomerComboSearchField", ((CustomerSearcher)this.getSearcher()).getIncompleteFilter(), null, GlazedLists.eventListOf((Object[])this.PROP_TO_ADD_TO_INCOMPLETE), GlazedLists.eventListOf((Object[])AbstractPolyPropertySearchFilter.Condition.values())));
        this.advancedPanel.addSearchFieldToAdvanced("Frequent Customers:", (SearchGuiField)new FrequentCustomerSearchField("FrequentCustomerSearchField", ((CustomerSearcher)this.getSearcher()).getFrequencyFilter(), null, GlazedLists.eventListOf((Object[])FrequentCustomerSearchFilter.UnitOfTime.values()), GlazedLists.eventListOf((Object[])FrequentCustomerSearchFilter.FrequentCustomerSearchType.values())));
        if (showButtonPanel) {
            this.addToSearchPanel(this.advancedPanel.getButtonPanel());
        }
    }

    public CustomerSearcherGui(EventList customerCategories, RefreshAction refreshArg) {
        this(customerCategories, refreshArg, true);
    }

    public CustomerSearcherGui(EventList customerCategories) {
        this(customerCategories, null);
    }

    public ObjectQuerySearcher<Customer> getSearcher() {
        return super.getPropertySearcher();
    }

    public AdvancedSearchComponent getAdvancedSearch() {
        return this.advancedPanel;
    }

    @Override
    protected ObjectQuerySearcher<Customer> constructPropertySearcher() {
        CustomerSearcher searcher = new CustomerSearcher();
        NewCustomerSearchFilter dateRangeFilter = searcher.getNewCustomerFilter();
        searcher.addSearchFilter((SearchFilterI)dateRangeFilter);
        return searcher;
    }

    public void addToEast(JComponent jComp) {
        this.addToSearchPanel(jComp);
        this.layoutSearchPanel();
    }
}

