/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.objectsearch;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.DateRangePanel;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.CheckBoxSearchField;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.SearchBarPanel;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.search.searchfield.ObjectSearchField;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.searchers.reports.debtor.DebtorSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DebtorSearchState
extends ObjectPropertySearch<AbstractDebtor>
implements ActionListener {
    private final RefreshAction refresh = new RefreshAction((Refreshable)this);
    public static final ColumnTableFormat DEFAULT_TABLE_FORMAT = new ColumnTableFormat(new ColumnFormat[]{new AbstractColumnFormat("Name", String.class){

        public Object resolveColumnValue(Object baseObject) {
            return ((AbstractDebtor)baseObject).getLabel();
        }
    }, new PropertyColumnFormat(AbstractDebtor.Properties.GROUP), new PropertyColumnFormat(AbstractDebtor.Properties.AMOUNT_OUTSTANDING)});
    private DateRangePanel dateRange;
    private JCheckBox searchByDateCheck;
    private JCheckBox showCogsCheck;
    private EventList allDebtorGroups = GlazedLists.eventList((Collection)DebtorGroup.getAllDebtorGroups());
    private EventList<CustomerCategory> allCustomerCategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
    private IRangedSearchFilter<Date> dateFilter;
    private DebtorSearcher searcher;

    public DebtorSearchState() {
        super(AbstractDebtor.class);
        this.refresh.setEnabled(false);
        this.searcher = (DebtorSearcher)super.getPropertySearcher();
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Group:", (Action)this.refresh, this.allDebtorGroups, null, this.searcher.getDebtorGroupFilter(), new JCheckBoxCellRenderer()));
        this.addSearchField((SearchGuiField)new StringSearchField("Account Name:", this.searcher.getDebtorNameFilter(), (Action)this.refresh));
        this.addSearchField(new ObjectSearchField(this.searcher.getCustomerFilter(), (OfficeMateObjectSearch)new CustomerSearcherGui((EventList)this.allCustomerCategories), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customer", (Action)this.refresh));
        this.addSearchField((SearchGuiField)new StatusSearchField(this.searcher.getDebtorStatusFilter(), (Action)this.refresh));
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(DateTimeUtils.getTwelveMonthsAgo());
        DateRangeSearchField date = new DateRangeSearchField("", this.searcher.getDateRangeFilter(), start.getTime(), (Action)this.refresh);
        this.dateRange = date.getDateRangePanel();
        this.dateFilter = date.getSearchProperty();
        this.addSearchField((SearchGuiField)date);
        this.setSystemStateFilterActive(true);
        this.addSearchField((SearchGuiField)new CheckBoxSearchField("Hide  " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN") + "0 balance", this.searcher.getOutstandingAmountFilter(), (Action)this.refresh).not().setComparisonValue((Object)0).filterWhenDeselected(false));
        CheckBoxSearchField showDeletedCheckBox = new CheckBoxSearchField("Show Deleted Debtors", this.searcher.getSystemStateFilter(), (Action)this.refresh).setComparisonValue((Object)0).filterWhenDeselected(false);
        showDeletedCheckBox.getGuiComponent().setName("showDeletedCheckBox");
        this.addSearchField((SearchGuiField)showDeletedCheckBox);
        this.refresh.setEnabled(true);
    }

    @Override
    public JPanel createSearchPanel() {
        SearchBarPanel panel = (SearchBarPanel)super.createSearchPanel();
        this.searchByDateCheck = new JCheckBox();
        this.searchByDateCheck.setName("searchByDateCheck");
        this.searchByDateCheck.setSelected(false);
        this.searchByDateCheck.addActionListener(this);
        this.showCogsCheck = new JCheckBox();
        this.showCogsCheck.setName("showCogs");
        this.showCogsCheck.setSelected(false);
        this.showCogsCheck.addActionListener(this);
        this.getDateRangePanel().setEnabled(false);
        panel.insertSearchFieldAfter("Search by date", this.searchByDateCheck, (Component)this.dateRange.getEndPicker());
        return panel;
    }

    @Override
    protected ObjectQuerySearcher<AbstractDebtor> constructPropertySearcher() {
        return new DebtorSearcher();
    }

    @Override
    public void resetSearch() {
        this.searchByDateCheck.setSelected(false);
        this.getDateRangePanel().setEnabled(false);
        super.resetSearch();
    }

    public DateRangePanel getDateRangePanel() {
        return this.dateRange;
    }

    @Override
    public void reaquireSearchOptions() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allDebtorGroups, DebtorGroup.getAllDebtorGroups());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allCustomerCategories, CustomerCategory.getAllCategories());
    }

    private void showCogs() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.searchByDateCheck) {
            this.getDateRangePanel().setEnabled(this.searchByDateCheck.isSelected());
            if (this.searchByDateCheck.isSelected()) {
                this.searcher.addSearchFilter(this.dateFilter);
            } else {
                this.searcher.removeSearchFilter(this.dateFilter);
            }
            this.refresh();
        } else if (source == this.showCogsCheck) {
            this.showCogs();
        }
    }

    private static class StatusSearchField
    extends ComboSearchField {
        private ISingleValueSearchFilter searchProperty;

        public StatusSearchField(ISingleValueSearchFilter searchProperty, Action refreshAction) {
            super("Status:", searchProperty, true, refreshAction, GlazedLists.eventList(Arrays.asList("Paid", "Outstanding", "Overdue")));
            this.searchProperty = searchProperty;
        }

        public SearchFilterI getSearchProperty() {
            Object value = this.getComboBox().getSelectedItem();
            this.searchProperty.clearSearch();
            if (value != null && !value.toString().equals("Any")) {
                this.searchProperty.setSearchValue(value);
            }
            return this.searchProperty;
        }
    }
}

