/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.refreshstrategy;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.util.List;
import officemate.components.search.AbstractRefreshStrategy;
import officemate.components.search.ObjectPropertySearch;

public class LimitObjectQueryStrategy
extends AbstractRefreshStrategy {
    public static final int PAGE_SIZE = 100;
    private static final int MAX_OBJECT_COUNT = 10000;
    private final int LIMIT_SIZE;

    public LimitObjectQueryStrategy(ObjectPropertySearch searcher, int limit) {
        super(searcher);
        this.LIMIT_SIZE = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performRefreshStrategy() {
        List newObjects;
        ObjectQuery oQuery;
        ObjectQuerySearcher propSearcher;
        int count = 0;
        List<SearchGuiField> list = this.getSearchFields();
        synchronized (list) {
            propSearcher = this.getPropertySearcher();
            oQuery = propSearcher.getObjectQuery();
        }
        do {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            ObjectQuery limitedOQuery = oQuery.copy();
            limitedOQuery.limit(this.LIMIT_SIZE, count);
            count += this.LIMIT_SIZE;
            newObjects = this.resolveObjectQuery(limitedOQuery, propSearcher.getPersistentClass());
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            this.copyIntoObjectList(newObjects);
            Thread.yield();
        } while (newObjects != null && newObjects.size() == 100 && count < 10000);
    }
}

