/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.refreshstrategy;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import officemate.components.search.AbstractRefreshStrategy;
import officemate.components.search.ObjectPropertySearch;
import ordermate.OrderMate;
import ordermate.database.reports.general.NumberReport;
import org.apache.commons.lang.StringUtils;

public class PagedObjectQueryStrategy
extends AbstractRefreshStrategy {
    private final Pager listPager;
    private final int BATCH_SIZE;

    public PagedObjectQueryStrategy(ObjectPropertySearch search, Pager pager) {
        super(search);
        int maxBatchSize = 100;
        this.listPager = pager;
        this.BATCH_SIZE = 100 < pager.getElementsPerPage() ? 100 : pager.getElementsPerPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performRefreshStrategy() {
        List newObjects;
        int max;
        ObjectQuery oQuery;
        ObjectQuerySearcher propSearcher;
        List<SearchGuiField> list = this.getSearchFields();
        synchronized (list) {
            propSearcher = this.getPropertySearcher();
            oQuery = propSearcher.getObjectQuery();
        }
        this.updatePager(oQuery.copy());
        boolean paged = this.listPager.isPaged();
        int count = paged ? this.listPager.getPageIndex() * this.listPager.getElementsPerPage() : 0;
        int n = max = paged ? count + this.listPager.getElementsPerPage() : this.listPager.getListSize();
        do {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            ObjectQuery limitedOQuery = oQuery.copy();
            limitedOQuery.limit(this.BATCH_SIZE, count);
            newObjects = this.resolveObjectQuery(limitedOQuery, propSearcher.getPersistentClass());
            count += newObjects.size();
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            this.copyIntoObjectList(newObjects);
            Thread.yield();
        } while (count < max && newObjects.size() == this.BATCH_SIZE);
    }

    private void updatePager(ObjectQuery query) {
        String queryString = query.toString();
        String querySuffix = queryString.substring(queryString.indexOf("FROM"), queryString.length());
        if (!querySuffix.startsWith("FROM")) {
            OrderMate.LOG.warn("Query suffix does not begin with FROM " + querySuffix, (Throwable)new Exception());
            return;
        }
        StringBuilder prefix = new StringBuilder("SELECT COUNT(*) AS value");
        if (!query.getHavings().isEmpty()) {
            this.keepHavingSelectStatements(query, prefix, querySuffix);
        }
        prefix.append(" ");
        prefix.append(querySuffix);
        final String countQuery = prefix.toString();
        try {
            Future<Integer> task = this.getDatabaseAccessService().submit(new Callable<Integer>(){

                @Override
                public Integer call() {
                    List reports = PersistenceManager.getObjectList(NumberReport.class, (String)countQuery);
                    int count = 0;
                    for (NumberReport report : reports) {
                        count += report.intValue();
                    }
                    return count;
                }
            });
            this.listPager.setListSize(task.get().intValue());
        }
        catch (InterruptedException ie) {
            OrderMate.LOG.info("Updating pager interrupted while waiting on get()");
            return;
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error updating pager", ex);
        }
    }

    private void keepHavingSelectStatements(ObjectQuery query, StringBuilder SB, String querySuffix) {
        for (QueryComponent having : query.getHavings()) {
            String havingString = having.toString();
            havingString = havingString.substring(0, StringUtils.indexOfAny((String)havingString, (String)" =()!"));
            for (QueryComponent component : query.getSelects()) {
                if (!component.toString().contains(havingString)) continue;
                SB.append(", ").append(component.toString());
            }
        }
    }
}

