/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.reports;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import officemate.components.search.reports.PeriodAdaptable;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class PeriodAdaptableSelector
extends JComboBox
implements ActionListener {
    private PeriodAdaptable myAdaptable;
    private PeriodReportAdapter currentPeriod;

    public PeriodAdaptableSelector() {
        this(PeriodReportAdapter.getStandardPeriods());
    }

    public PeriodAdaptableSelector(PeriodReportAdapter[] standardPeriods) {
        super(new DefaultComboBoxModel<PeriodReportAdapter>(standardPeriods));
        ComponentUtils.setupComboBox((JComboBox)this);
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                JLabel toReturn = null;
                if (comp instanceof JLabel) {
                    toReturn = (JLabel)comp;
                }
                if (value == null) {
                    toReturn.setText("Custom");
                }
                return toReturn;
            }
        });
        this.setName("periodSelector");
        this.currentPeriod = null;
        this.addActionListener(this);
        this.setEditable(false);
    }

    public void setPeriodAdaptable(PeriodAdaptable value) {
        this.myAdaptable = value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PeriodReportAdapter newPeriod;
        if (e.getSource() == this && this.myAdaptable != null && (newPeriod = (PeriodReportAdapter)this.getSelectedItem()) != this.currentPeriod) {
            this.currentPeriod = newPeriod;
            this.myAdaptable.adaptToPeriod(newPeriod);
        }
    }
}

