/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.searchfield;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.components.SearchableAddRemovePanel;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.database.misc.ServermateEventLog;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.misc.TerminalEventLog;

public class EventTypeSelectionField
extends SearchGuiField {
    private SearchableAddRemovePanel splitPanel;
    private JButton dialogButton;
    private OkCancelDialogBuilder dialogBox;
    private MultiOptionSearchFilter filter;
    private ArrayList<Action> actionQueue;

    public EventTypeSelectionField(MultiOptionSearchFilter aFilter, Action refresh, HashMap<String, List<String>> items) {
        super("", refresh);
        if (this.splitPanel == null) {
            this.splitPanel = new SearchableAddRemovePanel(items);
            this.splitPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        }
        if (this.actionQueue == null) {
            this.actionQueue = new ArrayList();
        }
        for (Action a : this.actionQueue) {
            this.addAction(a);
        }
        this.filter = aFilter;
        this.dialogButton = new JButton((Action)((Object)new DialogAction()));
        this.dialogButton.setText("Advanced...");
    }

    public void reset() {
        this.filter.clearSearch();
    }

    public SearchFilterI getSearchProperty() {
        this.filter.setSearchOptions(this.splitPanel.getAddedList());
        MultiOptionSearchFilter searchProp = this.filter;
        List selectedTypes = searchProp.getSelectedOptions();
        HashSet optionsToSelectSet = new HashSet(selectedTypes.size() * 2);
        if (selectedTypes.contains("All WaiterMate Events".toUpperCase())) {
            optionsToSelectSet.addAll(TerminalEventLog.getInst().getAllEvents());
        }
        if (selectedTypes.contains("All Stock Control Events".toUpperCase())) {
            optionsToSelectSet.addAll(StockControlEventLog.getInst().getAllEvents());
        }
        if (selectedTypes.contains("All OfficeMate Events".toUpperCase())) {
            optionsToSelectSet.addAll(OfficeMateEventLog.getInst().getAllEvents());
        }
        if (selectedTypes.contains("All ServerMate Events".toUpperCase())) {
            optionsToSelectSet.addAll(ServermateEventLog.getInst().getAllEvents());
        }
        searchProp.addSearchOptions(optionsToSelectSet);
        return searchProp;
    }

    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
    }

    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }

    public Component getGuiComponent() {
        return this.dialogButton;
    }

    public void addAction(Action action) {
        if (this.splitPanel == null) {
            if (this.actionQueue == null) {
                this.actionQueue = new ArrayList();
            }
            this.actionQueue.add(action);
        } else if (action != null) {
            this.splitPanel.addActionsToButtons(action);
        }
    }

    private class DialogAction
    extends BasicAction {
        private DialogAction() {
        }

        public void actionPerformed(ActionEvent e) {
            EventTypeSelectionField.this.dialogBox = Dialogs.getOkCancelDialogBuilder(EventTypeSelectionField.this.splitPanel).doPack();
            EventTypeSelectionField.this.dialogBox.setTitle("Event Type Filtering");
            EventTypeSelectionField.this.dialogBox.setIsResizable(false);
            if (!EventTypeSelectionField.this.dialogBox.doShow()) {
                EventTypeSelectionField.this.splitPanel.resetPanel();
            }
        }
    }
}

