/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.searchfield;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.AbstractSearchDialog;
import officemate.components.search.MultiItemSearchDialog;
import officemate.components.search.SingleSearchDialog;
import officemate.components.tableformat.ColumnTableFormat;

public class ObjectSearchField
extends SearchGuiField
implements ActionListener,
PropertyChangeListener {
    private AbstractSearchDialog searchStateDialog;
    private SingleValueQuerySearchFilter searchProperty;
    private Object foundObject;
    private JButton searchButton = new JButton();
    private Action refreshAction;
    private boolean updating = false;

    public ObjectSearchField(PropertiedObject.Property prop, OfficeMateObjectSearch objectSearchState, ColumnTableFormat searchDialogFormat, String typeName) {
        this(prop, objectSearchState, searchDialogFormat, typeName, null);
    }

    public ObjectSearchField(PropertiedObject.Property prop, OfficeMateObjectSearch objectSearchState, ColumnTableFormat searchDialogFormat, String typeName, Action action) {
        this((SingleValueQuerySearchFilter)new ObjectSearchFilter(prop), objectSearchState, searchDialogFormat, typeName, action);
    }

    public ObjectSearchField(SingleValueQuerySearchFilter searchProp, OfficeMateObjectSearch objectSearchState, ColumnTableFormat searchDialogFormat, String typeName, Action action) {
        this(searchProp, objectSearchState, searchDialogFormat, typeName, action, false, null);
    }

    public ObjectSearchField(SingleValueQuerySearchFilter searchProp, OfficeMateObjectSearch objectSearchState, ColumnTableFormat searchDialogFormat, String typeName, Action action, boolean multiSelect) {
        this(searchProp, objectSearchState, searchDialogFormat, typeName, action, multiSelect, null);
    }

    public ObjectSearchField(SingleValueQuerySearchFilter searchProp, OfficeMateObjectSearch objectSearchState, ColumnTableFormat columns, String typeName, Action refresh, boolean multiSelect, ImageIcon dialogIcon) {
        super(typeName + ": ", refresh);
        ImageIcon iconToUse = dialogIcon;
        if (iconToUse == null) {
            iconToUse = IconLoader.get((String)"/ordermate/images/ordermate_icon.png");
        }
        this.searchStateDialog = multiSelect ? new MultiItemSearchDialog(objectSearchState, columns, typeName, iconToUse) : new SingleSearchDialog(objectSearchState, columns, typeName, iconToUse);
        this.searchProperty = searchProp;
        this.foundObject = this.searchProperty.getSearchValue();
        this.searchProperty.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.foundObject == null || this.foundObject instanceof Collection && ((Collection)this.foundObject).isEmpty()) {
            this.searchButton.setText("   Any   ");
        } else {
            this.searchButton.setText(this.foundObject.toString());
        }
        this.searchButton.setPreferredSize(new Dimension(125, 25));
        this.searchButton.addActionListener(this);
    }

    public QuerySearchFilter getSearchProperty() {
        return this.searchProperty;
    }

    public Component getGuiComponent() {
        return this.searchButton;
    }

    public void reset() {
        this.searchButton.setText("   Any   ");
        this.foundObject = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updating = true;
        if (this.isEnabled()) {
            if (e.getSource().equals(this.searchButton)) {
                this.foundObject = this.searchStateDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
                if (this.foundObject != null) {
                    this.searchButton.setText(this.foundObject.toString());
                } else {
                    this.reset();
                }
                this.searchProperty.setSearchValue(this.foundObject);
                if (this.refreshAction != null) {
                    this.refreshAction.actionPerformed(e);
                }
            }
        } else {
            this.searchProperty.setSearchValue(null);
        }
        this.updating = false;
    }

    public void addAction(Action action) {
        this.refreshAction = action;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.updating) {
            this.foundObject = this.searchProperty.getSearchValue();
            this.searchButton.setText(this.foundObject.toString());
        }
    }

    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
        if (!flag) {
            this.searchProperty.setSearchValue(null);
        }
    }

    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

