/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.search.searchfield;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXDatePicker;

public class PeriodReportSelector
extends SearchGuiField
implements ActionListener {
    private JPanel holder;
    private JXDatePicker dateField;
    private JLabel periodLabel;
    private JComboBox periodSelect;
    public final Signal changed = Signals.createSignal();
    private PeriodReportAdapter lastAdapter = PeriodReportAdapter.WEEK_ENDING;

    public PeriodReportSelector(String label, Action refresh) {
        super(label, refresh);
        this.holder = new JPanel();
        this.setupComponents();
    }

    private void setupComponents() {
        this.dateField = new JXDatePicker();
        this.dateField.setFormats(new String[]{"dd/MM/yy"});
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (PeriodReportAdapter adapter : PeriodReportAdapter.getStandardPeriods()) {
            model.addElement(adapter.getTitle());
        }
        this.periodSelect = new JComboBox(model);
        this.periodLabel = new JLabel();
        this.dateField.addActionListener((ActionListener)this);
        this.periodSelect.addActionListener(this);
        this.holder.add(new JLabel("Period"));
        this.holder.add(this.periodSelect);
        this.holder.add(new JLabel("Inclusive Date"));
        this.holder.add((Component)this.dateField);
        this.holder.add(this.periodLabel);
        ComponentUtils.setupComboBox((JComboBox)this.periodSelect);
        this.updateLabel();
    }

    public Date getStartDate() {
        PeriodReportAdapter adapter = this.getAdapter();
        Date date = this.dateField.getDate();
        if (date == null) {
            date = new Date();
        }
        return adapter.getDateOffset().calcStart(date);
    }

    public Date getEndDate() {
        PeriodReportAdapter adapter = this.getAdapter();
        Date date = this.dateField.getDate();
        if (date == null) {
            date = new Date();
        }
        return adapter.getDateOffset().calcEnd(date);
    }

    public PeriodReportAdapter getAdapter() {
        String choice = (String)this.periodSelect.getSelectedItem();
        if (choice == null || this.lastAdapter.getTitle().equals(choice)) {
            return this.lastAdapter;
        }
        for (PeriodReportAdapter adapter : PeriodReportAdapter.getStandardPeriods()) {
            if (!adapter.getTitle().equals(choice)) continue;
            this.lastAdapter = adapter;
        }
        return this.lastAdapter;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.updateLabel();
        this.changed.emit();
    }

    private void updateLabel() {
        PeriodReportAdapter adapter = this.getAdapter();
        if (PeriodReportAdapter.DAILY.equals(adapter)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
            this.periodLabel.setText(dateFormat.format(this.getStartDate()));
        } else if (PeriodReportAdapter.WEEK_ENDING.equals(adapter)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
            this.periodLabel.setText("Week ending " + dateFormat.format(this.getStartDate()));
        } else {
            this.periodLabel.setText(adapter.formatRangeForDisplay(this.getStartDate(), this.getEndDate()));
        }
    }

    public void reset() {
        this.dateField.setDate(new Date());
    }

    public void setVisible(boolean flag) {
    }

    public boolean isVisible() {
        return true;
    }

    public void setEnabled(boolean flag) {
        this.periodSelect.setEnabled(flag);
        this.dateField.setEnabled(flag);
    }

    public boolean isEnabled() {
        return this.periodSelect.isEnabled();
    }

    public void addAction(Action action) {
    }

    public SearchFilterI getSearchProperty() {
        return null;
    }

    public Component getGuiComponent() {
        return this.holder;
    }
}

