/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.strategy;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JOptionPane;
import officemate.components.strategy.SaveStrategy;
import officemate.components.strategy.StrategySaveCancelListener;
import ordermate.database.misc.SystemCurrentInfo;

public abstract class AbstractSaveStrategy<T>
implements SaveStrategy<T> {
    private long updateVersionMask = 0L;
    public static final long UPDATES_MENU = 1L;
    public static final long UPDATES_TABLES = 16L;
    public static final long UPDATES_LAST_MODIFICATION = 256L;
    private List<StrategySaveCancelListener> saveCancelListeners = new ArrayList<StrategySaveCancelListener>();

    public AbstractSaveStrategy(long updateMask) {
        this.updateVersionMask = updateMask;
    }

    @Override
    public void promptForSave(Component parentComp) {
        if (this.isChanged()) {
            int n = JOptionPane.showConfirmDialog(parentComp, " Do you want to save your changes?", "Save changes", 0);
            if (n == 0) {
                this.save();
                this.clear();
            } else {
                this.clear();
            }
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public List<? extends Action> getActions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void addSaveCancelListener(StrategySaveCancelListener saveCancelListener) {
        this.saveCancelListeners.add(saveCancelListener);
    }

    protected void notifyListenersPreSave() {
        for (StrategySaveCancelListener listener : this.saveCancelListeners) {
            listener.preSave();
        }
    }

    protected void notifyListenersPreCancel() {
        for (StrategySaveCancelListener listener : this.saveCancelListeners) {
            listener.preCancel();
        }
    }

    protected void notifyListenersPostSave() {
        for (StrategySaveCancelListener listener : this.saveCancelListeners) {
            listener.postSave();
        }
    }

    protected void updateVersionInformation(String reason) {
        if (this.isUpdateRequired(1L)) {
            SystemCurrentInfo.setMenuUpdate((String)reason);
        }
        if (this.isUpdateRequired(16L)) {
            SystemCurrentInfo.setTablesUpdate((String)reason);
        }
        if (this.isUpdateRequired(256L) && !this.isUpdateRequired(1L) && !this.isUpdateRequired(16L)) {
            SystemCurrentInfo.setUpdate((String)reason);
        }
    }

    private boolean isUpdateRequired(long versionMask) {
        return (this.updateVersionMask & versionMask) != 0L;
    }
}

