/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.strategy;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.SuperSaveable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import officemate.components.strategy.AbstractSaveStrategy;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.gui.dialogs.ProgressDialog;

public class DeferredSaveStrategy<T extends PersistentObject>
extends AbstractSaveStrategy<T> {
    private final Set<T> saveSet = new HashSet<T>();
    private final Set<T> deleteSet = new HashSet<T>();
    private final Object setGuard = new Object();
    private BasicAction saveAction = new SaveAction();
    private BasicAction cancelAction = new CancelAction();
    private BasicAction[] actions = new BasicAction[]{this.saveAction, this.cancelAction};
    private Refreshable listObject;
    private PropertyChangeSupport pcs;
    private boolean refreshOnSave = true;
    private boolean doPersistentCheckAfterSave = true;

    public DeferredSaveStrategy(Refreshable refreshableObjectList) {
        this(refreshableObjectList, 256L);
    }

    public DeferredSaveStrategy(Refreshable refreshableObjectList, long updateMask) {
        super(updateMask);
        this.listObject = refreshableObjectList;
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public List<? extends Action> getActions() {
        return Arrays.asList(this.actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectNeedsDeleting(T toDelete) {
        boolean oldChanged = this.isChanged();
        Object object = this.setGuard;
        synchronized (object) {
            this.saveSet.remove(toDelete);
            this.deleteSet.add(toDelete);
        }
        this.pcs.firePropertyChange("changed", oldChanged, true);
        this.checkAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectNeedsSaving(T toSave) {
        boolean oldChanged = this.isChanged();
        Object object = this.setGuard;
        synchronized (object) {
            this.deleteSet.remove(toSave);
            this.saveSet.add(toSave);
        }
        this.pcs.firePropertyChange("changed", oldChanged, true);
        this.checkAction();
    }

    private void checkAction() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeferredSaveStrategy.this.saveAction.setEnabled(DeferredSaveStrategy.this.isChanged());
                DeferredSaveStrategy.this.cancelAction.setEnabled(DeferredSaveStrategy.this.isChanged());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        boolean oldChanged = this.isChanged();
        this.notifyListenersPreCancel();
        Object object = this.setGuard;
        synchronized (object) {
            this.saveSet.clear();
            this.deleteSet.clear();
        }
        this.pcs.firePropertyChange("changed", oldChanged, false);
        this.checkAction();
    }

    @Override
    public final void save() {
        this.notifyListenersPreSave();
        new ProgressDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), true, (Task)this.getSaveTask()).start();
        if (this.isRefreshOnSave()) {
            this.listObject.refresh();
        }
        this.notifyListenersPostSave();
    }

    public void removeFromSaveOrDelete(T value) {
        this.saveSet.remove(value);
        this.deleteSet.remove(value);
    }

    private AbstractTask getSaveTask() {
        return new AbstractTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected int getTotalSubTasks() {
                int size = 0;
                Object object = DeferredSaveStrategy.this.setGuard;
                synchronized (object) {
                    size = DeferredSaveStrategy.this.saveSet.size() + DeferredSaveStrategy.this.deleteSet.size();
                }
                return size;
            }

            public String getName() {
                return "Saving...";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                HashSet localDeleteSet;
                HashSet localSaveSet;
                Iterator iterator = DeferredSaveStrategy.this.setGuard;
                synchronized (iterator) {
                    localSaveSet = new HashSet(DeferredSaveStrategy.this.saveSet);
                    localDeleteSet = new HashSet(DeferredSaveStrategy.this.deleteSet);
                }
                DeferredSaveStrategy.this.clear();
                for (PersistentObject toDelete : localDeleteSet) {
                    DeferredSaveStrategy.this.performDelete((SuperSaveable)toDelete);
                    this.emitProgress();
                }
                OfficeMateEventLog.getInst().logObjectDeletion(localDeleteSet, GuiApp.getAppComplex().getApplicationSecurity().getUser());
                for (PersistentObject toSave : localSaveSet) {
                    DeferredSaveStrategy.this.performSave(toSave);
                    this.emitProgress();
                }
                localDeleteSet.clear();
                localSaveSet.clear();
                DeferredSaveStrategy.this.updateVersionInformation("Changes saved [" + DeferredSaveStrategy.this.listObject.getClass().getName() + "]");
            }
        };
    }

    protected void performDelete(SuperSaveable toDelete) {
        if (toDelete instanceof Saveable) {
            ((Saveable)toDelete).delete();
        } else if (toDelete instanceof SaveableChild) {
            ((SaveableChild)toDelete).deleteChild();
        } else {
            throw new IllegalArgumentException(toDelete.getClass() + " does not implment Saveable or Saveable child");
        }
    }

    protected void performSave(T toSave) {
        if (toSave instanceof Saveable) {
            Saveable saveObj = (Saveable)toSave;
            saveObj.save();
            if (this.doPersistentCheckAfterSave && saveObj instanceof PersistentObjectI && !((PersistentObjectI)saveObj).isPersistent()) {
                throw new IllegalStateException("Could not save " + saveObj + ".  Object is not persistent after saving.");
            }
        } else if (toSave instanceof SaveableChild) {
            SaveableChild saveObj = (SaveableChild)toSave;
            saveObj.saveChild();
            if (this.doPersistentCheckAfterSave && !saveObj.isPersistent()) {
                throw new IllegalStateException("Could not save " + saveObj + ".  Object is not persistent after saving.");
            }
        } else {
            PersistenceManager.getInstance().saveUnmanaged(toSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isChanged() {
        Object object = this.setGuard;
        synchronized (object) {
            return !this.deleteSet.isEmpty() || !this.saveSet.isEmpty();
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public final DeferredSaveStrategy<T> setRefreshOnSave(boolean doRefreshOnSave) {
        this.refreshOnSave = doRefreshOnSave;
        return this;
    }

    public final boolean isRefreshOnSave() {
        return this.refreshOnSave;
    }

    public void setDoPersistentCheckAfterSave(boolean doPersistentCheckAfterSave) {
        this.doPersistentCheckAfterSave = doPersistentCheckAfterSave;
    }

    protected final class CancelAction
    extends BasicAction {
        public CancelAction() {
            super("Cancel", (Icon)IconLoader.get((String)"/ordermate/images/button_cancel.png"), "Cancel");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int n;
            if (DeferredSaveStrategy.this.isChanged() && (n = JOptionPane.showConfirmDialog(null, "The currents changes have not been saved and will be lost. Do you want to continue?", "Cancel change", 0)) != 0) {
                return;
            }
            DeferredSaveStrategy.this.clear();
            if (DeferredSaveStrategy.this.listObject != null) {
                DeferredSaveStrategy.this.listObject.refresh();
            }
        }
    }

    protected final class SaveAction
    extends BasicAction {
        public SaveAction() {
            super("Save", (Icon)IconLoader.get((String)"/ordermate/images/save.png"), "Save");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            DeferredSaveStrategy.this.save();
        }
    }
}

