/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.strategy;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import officemate.components.strategy.AbstractSaveStrategy;
import ordermate.database.misc.OfficeMateEventLog;

class InstantSaveStrategy<T extends PersistentObject>
extends AbstractSaveStrategy<T> {
    public InstantSaveStrategy() {
        this(256L);
    }

    public InstantSaveStrategy(long updateMask) {
        super(updateMask);
    }

    @Override
    public void objectNeedsSaving(T toSave) {
        if (toSave instanceof Saveable) {
            ((Saveable)toSave).save();
        } else if (toSave instanceof SaveableChild) {
            ((SaveableChild)toSave).saveChild();
        } else {
            PersistenceManager.getInstance().saveUnmanaged(toSave);
        }
        this.updateVersionInformation("Object " + toSave + " was saved");
    }

    @Override
    public void objectNeedsDeleting(T toDelete) {
        OfficeMateEventLog.getInst().logObjectDeletion(toDelete, GuiApp.getAppComplex().getApplicationSecurity().getUser());
        if (toDelete instanceof Saveable) {
            ((Saveable)toDelete).delete();
        } else if (toDelete instanceof SaveableChild) {
            ((SaveableChild)toDelete).deleteChild();
        } else {
            throw new IllegalArgumentException(toDelete.getClass() + " does not implment Saveable or Saveable child");
        }
        this.updateVersionInformation("Object " + toDelete + " was deleted");
    }
}

