/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import au.com.ordermate.gui.DragScrollListener;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.renderers.ColorCellEditor;
import officemate.components.tableformat.renderers.ColorCellRenderer;
import officemate.components.tableformat.renderers.DisplayableCellRenderer;
import officemate.components.tableformat.renderers.PriceCellEditor;
import officemate.components.tableformat.renderers.ToStringCellRenderer;
import ordermate.database.config.Quantity;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.search.SearchFactory;

public abstract class AbstractTableCentralArea<T>
extends JPanel
implements TableStateCentralArea<T> {
    private final Signal noObjectSelected = Signals.createSignal();
    private final Signal objectDoubleClicked = Signals.createSignal(Object.class, (String)"Selected object");
    private final Signal objectSelected = Signals.createSignal(Object.class, (String)"Selected object");
    private final Signal objectEdited = Signals.createSignal(Object.class, (String)"edited object");
    private final List<Action> selectionDependentActions = new ArrayList<Action>();
    private final List<ListSelectionListener> selectionListeners = new ArrayList<ListSelectionListener>();

    @Override
    public Signal noObjectSelected() {
        return this.noObjectSelected;
    }

    @Override
    public Signal objectDoubleClicked() {
        return this.objectDoubleClicked;
    }

    @Override
    public Signal objectSelected() {
        return this.objectSelected;
    }

    @Override
    public Signal objectEdited() {
        return this.objectEdited;
    }

    protected abstract EventTableModel<T> getModel();

    @Override
    public List<T> getAllSelectedObjects() {
        int[] rows = this.getTable().getSelectedRows();
        ArrayList<Object> selectedObjects = new ArrayList<Object>(rows.length);
        for (int row : rows) {
            Object selected = this.getModel().getElementAt(this.getTable().convertRowIndexToModel(row));
            selectedObjects.add(selected);
        }
        return selectedObjects;
    }

    @Override
    public final JComponent getComponent() {
        return this;
    }

    @Override
    public Action getFindAction() {
        return new BasicAction("Search", IconLoader.get((String)"/ordermate/images/search22.png"), "Search"){

            public void actionPerformed(ActionEvent e) {
                SearchFactory.getInstance().showFindInput((JComponent)AbstractTableCentralArea.this.getTable(), AbstractTableCentralArea.this.getTable().getSearchable());
            }
        };
    }

    @Override
    public abstract T getSelectedObject();

    @Override
    public abstract JXTable getTable();

    protected void configureTable(JXTable newTable) {
        this.configureTable(newTable, true);
    }

    protected void configureTable(JXTable newTable, boolean addHighlighter) {
        newTable.setColumnControlVisible(true);
        if (addHighlighter) {
            newTable.addHighlighter(HighlighterFactory.createSimpleStriping((Color)ShadeAlternateRowsTableCellRenderer.ODD_COLOR));
        }
        newTable.setSelectionMode(2);
        newTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(final ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                    int selectedRow = selectionModel.getAnchorSelectionIndex();
                    List selectedObj = AbstractTableCentralArea.this.resolveObjectsFromRowIndex(selectedRow);
                    if (selectionModel == null || selectionModel.isSelectionEmpty() || selectedRow == -1 || selectedObj.isEmpty()) {
                        AbstractTableCentralArea.this.noObjectSelected.emit();
                        AbstractTableCentralArea.this.updateSelectionDependentActions(false);
                    } else {
                        AbstractTableCentralArea.this.objectSelected.emit(selectedObj.get(0));
                        AbstractTableCentralArea.this.updateSelectionDependentActions(true);
                    }
                    for (final ListSelectionListener listener : AbstractTableCentralArea.this.selectionListeners) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                listener.valueChanged(e);
                            }
                        });
                    }
                }
            }
        });
        newTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    List selectedObjects;
                    Point p = e.getPoint();
                    int selectedRow = AbstractTableCentralArea.this.getTable().rowAtPoint(p);
                    if (selectedRow != -1 && (selectedObjects = AbstractTableCentralArea.this.resolveObjectsFromRowIndex(selectedRow)).size() == 1) {
                        AbstractTableCentralArea.this.objectDoubleClicked.emit(selectedObjects.get(0));
                    }
                }
            }
        });
        newTable.setDefaultRenderer(Price.class, (TableCellRenderer)new DefaultTableCellRenderer());
        newTable.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorCellRenderer());
        newTable.setDefaultRenderer(Quantity.class, (TableCellRenderer)new ToStringCellRenderer());
        DisplayableCellRenderer dispRenderer = new DisplayableCellRenderer();
        newTable.setDefaultRenderer(PersistentDisplayableObject.class, (TableCellRenderer)dispRenderer);
        newTable.setDefaultRenderer(PersistentEnumeration.class, (TableCellRenderer)dispRenderer);
        newTable.setDefaultEditor(Color.class, (TableCellEditor)new ColorCellEditor());
        newTable.setDefaultEditor(Price.class, (TableCellEditor)new PriceCellEditor());
    }

    protected List<T> resolveObjectsFromRowIndex(int ... selectionIndices) {
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (int selectedIndex : selectionIndices) {
            if (selectedIndex < 0 || selectedIndex >= this.getTable().getRowCount()) continue;
            selectedObjects.add(this.getModel().getElementAt(this.getTable().convertRowIndexToModel(selectedIndex)));
        }
        return selectedObjects;
    }

    @Override
    public void addSelectionDependentAction(Action toRegister) {
        this.selectionDependentActions.add(toRegister);
        toRegister.setEnabled(this.hasSelectedObject());
    }

    private void updateSelectionDependentActions(boolean hasSelectedObject) {
        for (Action selectionDependentAction : this.selectionDependentActions) {
            selectionDependentAction.setEnabled(hasSelectedObject);
        }
    }

    @Override
    public boolean hasSelectedObject() {
        return this.getSelectedObject() != null;
    }

    @Override
    public void addSelectionChangeListener(ListSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void enableTouchscreenScrolling() {
        JXTable table = this.getTable();
        DragScrollListener dsl = new DragScrollListener((Component)table);
        table.addMouseListener((MouseListener)dsl);
        table.addMouseMotionListener((MouseMotionListener)dsl);
    }
}

