/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.pager.PagerModel;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.Printing;
import officemate.adminkit.print.ReportPrintParams;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.controls.PagerPanel;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.TableStateCentralArea;
import ordermate.OrderMate;
import ordermate.database.users.Permission;
import ordermate.reports.printing.HeaderSubReport;

public abstract class AbstractTableState<T>
extends BasicOfficeMateState {
    protected boolean initCalled;
    private TableStateCentralArea<T> centralArea;
    private OfficeMateObjectSearch<T> search;
    private boolean usePrintAction = true;
    private List<Action> selectionDependentActions = new ArrayList<Action>();
    private List<ListSelectionListener> selectionChangeListeners = new ArrayList<ListSelectionListener>();
    private JPanel statusPanel;
    private static HeaderSubReport report = null;

    public AbstractTableState(Permission permission) {
        this("", permission, "");
    }

    public AbstractTableState(String stateName, Permission permission, String description) {
        super(stateName, permission, description);
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.search = this.createSearchPanelFactory();
        this.centralArea = this.createCentralArea();
        for (Action action : this.selectionDependentActions) {
            this.centralArea.addSelectionDependentAction(action);
        }
        for (ListSelectionListener listener : this.selectionChangeListeners) {
            this.centralArea.addSelectionChangeListener(listener);
        }
        JPanel screenPanel = new JPanel();
        screenPanel.setLayout(new BorderLayout());
        this.addAction(this.centralArea.getFindAction());
        if (this.getControlPanel() != null) {
            screenPanel.add((Component)this.getControlPanel(), "North");
        }
        screenPanel.add((Component)this.centralArea.getComponent(), "Center");
        this.setScreenPanel(screenPanel);
        this.getCentralArea().objectDoubleClicked().disconnectAll();
        this.getCentralArea().objectDoubleClicked().connect((Object)this, "gotObjectDoubleClicked");
        this.initCalled = true;
    }

    public void addSelectionDependentAction(Action toAdd) {
        this.addAction(toAdd);
        if (this.getCentralArea() != null) {
            this.getCentralArea().addSelectionDependentAction(toAdd);
        }
        this.selectionDependentActions.add(toAdd);
    }

    public boolean actionExists(Action a) {
        return this.selectionDependentActions.contains(a);
    }

    public void addSelectionChangeListener(ListSelectionListener listener) {
        if (this.getCentralArea() != null) {
            this.getCentralArea().addSelectionChangeListener(listener);
        }
        this.selectionChangeListeners.add(listener);
    }

    protected void addSelectionDependentAction(Action toAdd, Action precedingAction) {
        toAdd.setEnabled(false);
        if (this.getCentralArea() != null) {
            this.getCentralArea().addSelectionDependentAction(toAdd);
        }
        this.selectionDependentActions.add(toAdd);
    }

    protected abstract TableStateCentralArea<T> createCentralArea();

    protected OfficeMateObjectSearch<T> createSearchPanelFactory() {
        return new ObjectPropertySearch<T>(this.getDisplayingType());
    }

    protected OfficeMateObjectSearch<T> getSearchFactory() {
        return this.search;
    }

    protected abstract Class<T> getDisplayingType();

    public EventList<T> getObjectList() {
        return this.getSearchFactory().getObjectList();
    }

    public final TableStateCentralArea<T> getCentralArea() {
        if (this.centralArea == null) {
            this.init();
        }
        return this.centralArea;
    }

    public void setUsePrintAction(boolean useIt) {
        this.usePrintAction = useIt;
        this.toggleDefaultAction(this.getPrintAction(), this.usePrintAction);
    }

    public void gotObjectDoubleClicked(T toEdit) {
    }

    @Override
    protected void onStart() {
        if (!this.initCalled) {
            this.init();
            this.initCalled = true;
        }
        if (this.search != null) {
            this.search.reaquireSearchOptions();
        }
    }

    @Override
    protected void onEnd() {
        if (this.search != null) {
            this.search.stopRefresh();
        }
        EventList<T> list = null;
        try {
            list = this.getObjectList();
            list.getReadWriteLock().writeLock().lock();
            this.getObjectList().clear();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't close off table", (Throwable)ex);
        }
        finally {
            if (list != null) {
                list.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    protected JPanel getControlPanel() {
        return this.getSearchFactory().getSearchPanel();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.initCalled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractTableState.this.search.refresh(new Runnable(){

                        @Override
                        public void run() {
                            AbstractTableState.this.postRefresh();
                        }
                    });
                }
            });
        }
        this.fireResizeEvent();
    }

    private void fireResizeEvent() {
        JPanel searchPanel;
        if (this.search != null && (searchPanel = this.search.getSearchPanel()) != null) {
            Rectangle rectangle = searchPanel.getBounds();
            searchPanel.setBounds(new Rectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1));
            searchPanel.dispatchEvent(new ComponentEvent(searchPanel, 101));
        }
    }

    protected void postRefresh() {
        this.getCentralArea().getTable().packAll();
    }

    protected void setFilterActive(boolean active) {
        this.getSearchFactory().setSystemStateFilterActive(active);
    }

    @Override
    public boolean supportsPrint() {
        return this.usePrintAction;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void doPrintAction() {
        this.doPrint();
    }

    private void doPrint() {
        this.prepareReport();
        try {
            Printing.printJXTableReport(this.getCentralArea().getTable(), this.getControlPanel(), new ReportPrintParams().setTitle(this.getName() + " Report").setSubtitle("(" + DateFormat.getDateInstance().format(new Date()) + ")").setFontSize(8));
        }
        catch (Exception e1) {
            OrderMate.LOG.error("Error printing", (Throwable)e1);
            Dialogs.showErrorDialog("Error printing", "An error occured while printing");
        }
        finally {
            this.getScreenPanel().validate();
            this.refresh();
        }
    }

    private void prepareReport() {
        if (report == null) {
            try {
                report = new HeaderSubReport();
                report.generate();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Could not initialize report header.", (Throwable)ex);
            }
        }
    }

    protected void addPageControl(PagerModel model) {
        this.addStatusComponent(new PagerPanel(model, (Refreshable)this), "Center");
    }

    protected void addStatusComponent(Component comp, String position) {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel(new BorderLayout(0, 10));
            this.statusPanel.setBackground(this.getCentralArea().getTable().getBackground());
            this.getScreenPanel().add((Component)this.statusPanel, "South");
        }
        this.statusPanel.add(comp, position);
    }

    public JPanel getStatusPanel() {
        return this.statusPanel;
    }
}

