/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventJXTableModel;
import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.table.GroupedEventTableModel;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.GroupedTableModel;
import officemate.components.table.AbstractTableCentralArea;
import officemate.components.table.EditMultiple;
import officemate.components.table.TotalTableModel;
import officemate.components.table.TotalsTableModelBuilder;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditableColumnFormat;
import officemate.components.tableformat.ExcelAdapter;
import ordermate.OrderMate;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.ShuttleSorter;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.Sorter;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class PersistentObjectTable<T>
extends AbstractTableCentralArea<T> {
    private TotalsTableModelBuilder totalsBuilder;
    private TotalTableModel totalModel;
    private JXTable table;
    private JXTable ungroupedTable;
    private GroupedTable groupedTable;
    private EventTableModel<T> model;
    private ExcelAdapter excelAdapter;
    private PropertiedObject.Property[] propertiesToBulkExclude = null;
    private EditMultiple editMultiple;
    private EventList<T> originalList;
    private EventList list;
    private final ColumnFactory columnFactory = new ColumnFactory(){

        public void configureTableColumn(TableModel tableModel, TableColumnExt columnExt) {
            super.configureTableColumn(tableModel, columnExt);
            ColumnFormat colFormat = ((ColumnTableFormat)((EventTableModel)tableModel).getTableFormat()).getColumnFormat(columnExt.getModelIndex());
            columnExt.setIdentifier(colFormat.getIdentifier());
        }
    };

    public PersistentObjectTable(EventList<T> toShow, ColumnTableFormat format) {
        this(toShow, format, new PropertiedObject.Property[0]);
    }

    public PersistentObjectTable(EventList<T> toShow, PropertiedObject.Property[] propsToShow) {
        this(toShow, propsToShow, new PropertiedObject.Property[0]);
    }

    public PersistentObjectTable(EventList<T> toShow, PropertiedObject.Property[] propsToShow, PropertiedObject.Property[] propsToHide) {
        AbstractColumnFormat[] format = new AbstractColumnFormat[propsToShow.length];
        for (int i = 0; i < propsToShow.length; ++i) {
            format[i] = new PropertyColumnFormat(propsToShow[i]);
        }
        this.init(toShow, new ColumnTableFormat((ColumnFormat[])format), propsToHide);
    }

    public PersistentObjectTable(EventList<T> toShow, ColumnTableFormat format, PropertiedObject.Property[] defaultHiddenProps) {
        this.init(toShow, format, defaultHiddenProps);
    }

    private void init(EventList<T> toShow, ColumnTableFormat format, PropertiedObject.Property[] defaultHiddenProps) {
        this.setLayout(new BorderLayout());
        this.originalList = toShow;
        BasicEventList compositeList = new BasicEventList(this.originalList.getPublisher(), this.originalList.getReadWriteLock());
        compositeList.add(this.originalList);
        this.list = new CollectionList((EventList)compositeList, GlazedLists.listCollectionListModel());
        this.model = new EventJXTableModel(this.list, (TableFormat)format);
        format.objectEdited.connect((Object)this, "gotObjectEdited");
        this.ungroupedTable = this.createTable(this.model, defaultHiddenProps);
        this.registerRenderersAndEditors(this.ungroupedTable, format);
        this.excelAdapter = new ExcelAdapter(this.ungroupedTable, format, this.model);
        this.showTable(this.ungroupedTable);
    }

    protected JXTable createTable(EventTableModel<T> newTableModel, PropertiedObject.Property[] defaultHiddenProps) {
        JXTable newTable = this.createJXTable();
        newTable.setSurrendersFocusOnKeystroke(true);
        newTable.setFilters(new FilterPipeline(){

            protected SortController createDefaultSortController() {
                return new FilterPipeline.SorterBasedSortController(){

                    protected Sorter createDefaultSorter() {
                        return new ShuttleSorter(){

                            protected int compare(int row1, int row2) {
                                int eventListRow1 = this.mapTowardModel(row1);
                                int eventListRow2 = this.mapTowardModel(row2);
                                return super.compare(row1, row2);
                            }
                        };
                    }
                };
            }
        });
        newTable.setColumnFactory(this.columnFactory);
        newTable.setModel(newTableModel);
        for (PropertiedObject.Property defaultHiddenProp : defaultHiddenProps) {
            TableColumnExt columnExt = newTable.getColumnExt((Object)defaultHiddenProp);
            if (columnExt == null) {
                throw new IllegalStateException("Default hidden property does not exist in table :" + defaultHiddenProp);
            }
            columnExt.setVisible(false);
        }
        this.configureTable(newTable);
        return newTable;
    }

    protected JXTable createJXTable() {
        return new JXTable(){

            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                JTextComponent text;
                Component comp = super.prepareEditor(editor, row, column);
                if (comp instanceof JTextComponent && (text = (JTextComponent)comp).isEditable()) {
                    text.selectAll();
                    text.putClientProperty("DO_NOT_SELECT_TEXT", Boolean.TRUE);
                }
                return comp;
            }
        };
    }

    private void registerRenderersAndEditors(JXTable setupTable, ColumnTableFormat format) {
        for (int i = 0; i < format.getColumnCount(); ++i) {
            ColumnFormat col = format.getColumnFormat(i);
            TableColumnExt colModel = setupTable.getColumnExt(col.getIdentifier());
            if (col.getCustomRenderer() != null) {
                colModel.setCellRenderer(col.getCustomRenderer());
            }
            if (!(col instanceof EditableColumnFormat)) continue;
            EditableColumnFormat editableCol = (EditableColumnFormat)col;
            colModel.setCellEditor(editableCol.getCustomEditor());
        }
    }

    public EventList<T> getEventList() {
        return this.originalList;
    }

    @Override
    public T getSelectedObject() {
        int selectedIndex = this.table.getSelectionModel().getAnchorSelectionIndex();
        List<T> selectedObjects = this.resolveObjectsFromRowIndex(selectedIndex);
        if (selectedObjects != null && selectedObjects.size() > 0) {
            return selectedObjects.get(0);
        }
        return null;
    }

    @Override
    public List<T> getAllSelectedObjects() {
        int[] selectionIndices = this.table.getSelectedRows();
        return this.resolveObjectsFromRowIndex(selectionIndices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<T> resolveObjectsFromRowIndex(int ... selectionIndices) {
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        try {
            this.list.getReadWriteLock().readLock().lock();
            for (int selectedIndex : selectionIndices) {
                if (this.table == this.groupedTable) {
                    selectedIndex = ((GroupedTableModel)this.groupedTable.getModel()).getOriginalRow(selectedIndex);
                }
                if (selectedIndex < 0) {
                    ArrayList<Object> arrayList = selectedObjects;
                    return arrayList;
                }
                if (selectedIndex < 0 || selectedIndex >= this.table.getRowCount()) continue;
                try {
                    selectedObjects.add(this.model.getElementAt(this.table.convertRowIndexToModel(selectedIndex)));
                }
                catch (IndexOutOfBoundsException ex) {
                    OrderMate.LOG.error("Selected index no longer exists in table", (Throwable)ex);
                }
            }
            ArrayList<Object> arrayList = selectedObjects;
            return arrayList;
        }
        finally {
            this.list.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    protected EventTableModel<T> getModel() {
        return this.model;
    }

    public Object getObjectAt(int tableIndex) {
        try {
            this.list.getReadWriteLock().readLock().lock();
            Object object = this.model.getElementAt(this.table.convertRowIndexToModel(tableIndex));
            return object;
        }
        finally {
            this.list.getReadWriteLock().readLock().unlock();
        }
    }

    public int getObjectCount() {
        try {
            this.list.getReadWriteLock().readLock().lock();
            int n = this.model.getRowCount();
            return n;
        }
        finally {
            this.list.getReadWriteLock().readLock().unlock();
        }
    }

    public PropertiedObject.Property getColumnProperty(int columnIndex) {
        ColumnTableFormat tableFormat = (ColumnTableFormat)this.model.getTableFormat();
        ColumnFormat colFormat = tableFormat.getColumnFormat(this.table.convertColumnIndexToModel(columnIndex));
        if (colFormat instanceof PropertyColumnFormat) {
            return ((PropertyColumnFormat)colFormat).getProperty();
        }
        return null;
    }

    public Action getCopyAction() {
        return new BasicAction("Copy to Clipboard", IconLoader.get((String)"/officemate/images/copy.png"), "Copy the selected row to clipboard"){

            public void actionPerformed(ActionEvent e) {
                PersistentObjectTable.this.excelAdapter.copy();
            }
        };
    }

    public Action getEditMultipleAction() {
        return new BasicAction("Edit Multiple", IconLoader.get((String)"/ordermate/images/group22.png"), "Fills out table columns"){

            public void actionPerformed(ActionEvent e) {
                EditMultiple multiSelectEditor = PersistentObjectTable.this.getEditMultiple(PersistentObjectTable.this.propertiesToBulkExclude);
                boolean ok = Dialogs.getOkCancelDialogBuilder(multiSelectEditor).setTitle("Edit Multiple").doPack().doShow();
                if (ok) {
                    multiSelectEditor.save();
                    for (Object nextT : PersistentObjectTable.this.getAllSelectedObjects()) {
                        PersistentObjectTable.this.objectEdited().emit(nextT);
                    }
                } else {
                    multiSelectEditor.finish();
                }
            }
        };
    }

    private EditMultiple getEditMultiple(PropertiedObject.Property[] propertiesToExclude) {
        if (this.editMultiple == null) {
            this.editMultiple = this.createEditMultiple();
        }
        this.editMultiple.initialise(this, propertiesToExclude);
        return this.editMultiple;
    }

    protected EditMultiple createEditMultiple() {
        return new EditMultiple();
    }

    public void gotObjectEdited(Object editedObject) {
        this.objectEdited().emit(editedObject);
    }

    public PropertiedObject.Property[] getPropertiesToBulkExclude() {
        return Arrays.copyOf(this.propertiesToBulkExclude, this.propertiesToBulkExclude.length);
    }

    public void setPropertiesToBulkExclude(PropertiedObject.Property[] propertiesToExclude) {
        this.propertiesToBulkExclude = Arrays.copyOf(propertiesToExclude, propertiesToExclude.length);
    }

    public EventList getList() {
        return this.list;
    }

    public void setTotalsBuilder(TotalsTableModelBuilder builder) {
        this.totalsBuilder = builder;
        this.showTable(this.ungroupedTable);
    }

    private void showTable(JXTable tableToShow) {
        JScrollPane scroll;
        if (this.totalModel != null) {
            this.totalModel.releaseTable();
        }
        this.table = tableToShow;
        this.removeAll();
        if (this.table == this.ungroupedTable) {
            scroll = new JScrollPane((Component)tableToShow);
            scroll.setBorder(BorderFactory.createEmptyBorder());
        } else {
            scroll = this.groupedTable.getScroller();
        }
        this.add((Component)scroll, "Center");
        if (this.totalsBuilder != null) {
            JXTable totalTable = new JXTable();
            totalTable.setName("Totals");
            this.totalModel = this.totalsBuilder.createTotalTableModel(this.table, totalTable);
            this.add((Component)totalTable, "South");
        }
    }

    public void groupOn(String column, String ... totalsColumn) {
        if (column == null) {
            this.showTable(this.ungroupedTable);
        } else {
            if (this.groupedTable == null) {
                this.groupedTable = new GroupedTable(new GroupedEventTableModel(this.getList(), (EventTableModel)this.table.getModel(), column, totalsColumn), this.table.getColumns(true));
                this.groupedTable.setColumnFactory(this.columnFactory);
                this.groupedTable.setColumnControlVisible(this.ungroupedTable.isColumnControlVisible());
                this.configureTable(this.groupedTable, false);
                this.groupedTable.setSelectionMode(0);
            }
            if (!this.groupedTable.getGroupedTableModel().getGroupedColumn().equals(column)) {
                this.groupedTable.getGroupedTableModel().setGroupedColumn(column);
            }
            this.showTable(this.groupedTable);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public JXTable getTable() {
        return this.table;
    }
}

