/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionListener;
import officemate.components.table.TableStateCentralArea;
import ordermate.signals.Signal;
import org.jdesktop.swingx.JXTable;

public class SplitTableState<T>
implements TableStateCentralArea<T> {
    private JSplitPane split;
    private TableStateCentralArea<T> tableArea;
    private JComponent customComponent;
    private SplitOrientation splitOrientation;
    private int dividerLocation;

    public static <T> SplitTableState<T> createHorizontalSplit(JComponent theCustomComponent, TableStateCentralArea<T> mainTableArea) {
        return new SplitTableState<T>(theCustomComponent, mainTableArea, SplitOrientation.HORIZONTAL, theCustomComponent.getPreferredSize().width);
    }

    public static <T> SplitTableState<T> createVerticalSplit(JComponent theCustomComponent, TableStateCentralArea<T> mainTableArea) {
        return new SplitTableState<T>(theCustomComponent, mainTableArea, SplitOrientation.VERTICAL, theCustomComponent.getPreferredSize().height);
    }

    public SplitTableState(JComponent theCustomComponent, TableStateCentralArea<T> mainTableArea, SplitOrientation orientation, int locationOfDivider) {
        this.customComponent = theCustomComponent;
        this.tableArea = mainTableArea;
        this.splitOrientation = orientation;
        this.dividerLocation = locationOfDivider;
        this.setupComponents();
    }

    private int convertSplitOrientation() {
        if (this.splitOrientation == SplitOrientation.HORIZONTAL) {
            return 1;
        }
        if (this.splitOrientation == SplitOrientation.VERTICAL) {
            return 0;
        }
        throw new IllegalStateException("Unknown split orientation");
    }

    private void setupComponents() {
        this.split = new JSplitPane(this.convertSplitOrientation(), false);
        this.split.setDividerLocation(this.dividerLocation);
        JComponent left = null;
        JComponent right = null;
        if (this.splitOrientation == SplitOrientation.VERTICAL) {
            left = this.tableArea.getComponent();
            right = this.customComponent;
        } else {
            left = this.customComponent;
            right = this.tableArea.getComponent();
        }
        if (left != null) {
            this.split.setLeftComponent(left);
        }
        this.split.setRightComponent(right);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerSize(10);
    }

    public TableStateCentralArea<T> getWrappedTableArea() {
        return this.tableArea;
    }

    public JComponent getCustomComponent() {
        return this.customComponent;
    }

    @Override
    public void addSelectionDependentAction(Action toRegister) {
        this.tableArea.addSelectionDependentAction(toRegister);
    }

    @Override
    public List<T> getAllSelectedObjects() {
        return this.tableArea.getAllSelectedObjects();
    }

    @Override
    public JComponent getComponent() {
        return this.split;
    }

    @Override
    public Action getFindAction() {
        return this.tableArea.getFindAction();
    }

    @Override
    public T getSelectedObject() {
        return this.tableArea.getSelectedObject();
    }

    @Override
    public JXTable getTable() {
        return this.tableArea.getTable();
    }

    @Override
    public boolean hasSelectedObject() {
        return this.tableArea.hasSelectedObject();
    }

    @Override
    public Signal noObjectSelected() {
        return this.tableArea.noObjectSelected();
    }

    @Override
    public Signal objectDoubleClicked() {
        return this.tableArea.objectDoubleClicked();
    }

    @Override
    public Signal objectEdited() {
        return this.tableArea.objectEdited();
    }

    @Override
    public Signal objectSelected() {
        return this.tableArea.objectSelected();
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void addSelectionChangeListener(ListSelectionListener listener) {
        this.tableArea.addSelectionChangeListener(listener);
    }

    static enum SplitOrientation {
        VERTICAL,
        HORIZONTAL;

    }
}

