/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.EditorDialog;
import officemate.components.ListPropertyObjectEditor;
import officemate.components.controls.toolbar.CrudService;
import officemate.components.controls.toolbar.CrudToolBar;
import officemate.components.table.PersistentObjectTable;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class TableListObjectEditor<P, L>
extends ListPropertyObjectEditor<P, L>
implements CrudService {
    private PersistentObjectTable<L> objectTable;
    public final Signal objectEdited = Signals.createSignal();
    private ObjectEditor<L> elementEditor;
    private BasicOfficeMateState parentState;
    private Action newAction;
    private JToolBar toolBar;

    public TableListObjectEditor(PersistentObjectTable<L> newObjectTable) {
        this(newObjectTable, true);
    }

    public TableListObjectEditor(PersistentObjectTable<L> newObjectTable, boolean canCreateAndDelete) {
        this.toolBar = new JToolBar();
        if (canCreateAndDelete) {
            this.newAction = new NewAction();
            this.toolBar.add(this.newAction);
            DeleteAction deleteAction = new DeleteAction();
            newObjectTable.addSelectionDependentAction((Action)((Object)deleteAction));
            this.toolBar.add((Action)((Object)deleteAction));
        }
        this.toolBar.add(newObjectTable.getFindAction());
        this.init(newObjectTable, this.toolBar, true);
    }

    public TableListObjectEditor(PersistentObjectTable<L> newObjectTable, CrudToolBar toolBar) {
        this.init(newObjectTable, toolBar.getGuiComponent(), false);
        toolBar.setCrudService(this);
        this.newAction = toolBar.getAddAction();
        newObjectTable.addSelectionDependentAction(toolBar.getEditAction());
        newObjectTable.addSelectionDependentAction(toolBar.getRemoveAction());
        newObjectTable.addSelectionDependentAction(toolBar.getRemoveAllAction());
    }

    protected JToolBar getToolBar() {
        return this.toolBar;
    }

    private void init(PersistentObjectTable<L> newObjectTable, JComponent toolbar, boolean toolbarNorth) {
        this.setLayout(new BorderLayout());
        this.objectTable = newObjectTable;
        this.objectTable.objectEdited().connect((Object)this, "gotObjectEdited");
        this.objectTable.objectSelected().connect((Object)this, "gotObjectSelected");
        this.objectTable.objectDoubleClicked().connect((Object)this, "gotParentDoubleClicked");
        String layout = toolbarNorth ? "North" : "South";
        this.add((Component)toolbar, layout);
        this.add(this.objectTable, "Center");
    }

    public void gotParentDoubleClicked(Object obj) {
    }

    public void setElementEditor(ObjectEditor<L> editor) {
        this.elementEditor = editor;
    }

    public abstract L createNewObject();

    public PersistentObjectTable<L> getPersistentObjectTable() {
        return this.objectTable;
    }

    @Override
    public Collection<L> getGuiList() {
        return this.objectTable.getEventList();
    }

    @Override
    public void setGuiList(Collection<L> toDisplay) {
        if (this.objectTable.getTable().isEditing()) {
            this.objectTable.getTable().editingCanceled(new ChangeEvent(this.objectTable.getTable()));
        }
        this.getGuiList().clear();
        this.getGuiList().addAll(toDisplay);
    }

    public void gotObjectEdited(L editedObject) {
        this.objectEdited.emit();
    }

    public void gotObjectSelected(L selectedObject) {
    }

    @Override
    public void newElement() {
        L newElement = this.createNewObject();
        if (newElement != null) {
            this.objectTable.getEventList().add(newElement);
            this.gotObjectEdited(newElement);
        }
    }

    @Override
    public void editSelectedElement() {
        if (this.editElement(this.objectTable.getSelectedObject())) {
            this.gotObjectEdited(this.objectTable.getSelectedObject());
        }
    }

    public boolean editElement(L e) {
        if (this.elementEditor != null) {
            this.elementEditor.setObject(e);
            EditorDialog dialog = new EditorDialog(this.elementEditor);
            if (dialog.doModal() && this.elementEditor.isGuiValid()) {
                this.elementEditor.saveObject();
                return true;
            }
        } else {
            OrderMate.LOG.warn("No element editor for " + (e != null ? e.getClass() : "") + ", cannot edit element");
        }
        return false;
    }

    @Override
    public void removeSelectedElement() {
        List<L> toDelete = this.objectTable.getAllSelectedObjects();
        this.objectTable.getEventList().removeAll(toDelete);
        this.gotObjectEdited(null);
    }

    @Override
    public void removeAllElements() {
        this.objectTable.getEventList().clear();
        this.gotObjectEdited(null);
    }

    @Override
    public void setObject(P toEdit) {
        super.setObject(toEdit);
        if (toEdit != null) {
            this.setNewActionEnabled(true);
            if (!this.getGuiList().isEmpty()) {
                this.objectTable.getTable().getSelectionModel().setSelectionInterval(0, 0);
            }
        } else {
            this.setNewActionEnabled(false);
        }
    }

    public void setNewActionEnabled(boolean enabledIt) {
        if (this.newAction != null && this.newAction.isEnabled() != enabledIt) {
            this.newAction.setEnabled(enabledIt);
        }
    }

    public PersistentObjectTable<L> getObjectTable() {
        return this.objectTable;
    }

    private class NewAction
    extends BasicAction {
        public NewAction() {
            super("New", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Create New");
        }

        public void actionPerformed(ActionEvent e) {
            TableListObjectEditor.this.newElement();
        }
    }

    private class DeleteAction
    extends BasicAction {
        public DeleteAction() {
            super("Delete", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Delete");
        }

        public void actionPerformed(ActionEvent e) {
            TableListObjectEditor.this.removeSelectedElement();
        }
    }
}

