/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.components.table.TableStateCentralArea;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class TableModelCentralArea
implements TableStateCentralArea {
    private TableModel model;
    private JXTable table;
    private JPanel holder;
    final Signal<Object, ?, ?, ?, ?> dummySignal = Signals.createSignal(Object.class, (String)"stupidObject");
    private final int AUTO_RESIZE_MODE;

    public TableModelCentralArea(boolean autoResizeColumns) {
        this.model = new DefaultTableModel();
        this.table = new JXTable(this.model);
        this.table.setEditable(false);
        this.AUTO_RESIZE_MODE = autoResizeColumns ? 4 : 0;
    }

    public void setTableModel(TableModel newModel) {
        this.model = newModel;
        this.table.setModel(this.model);
    }

    public void enableAlternateRowHighlighting() {
        this.table.addHighlighter(HighlighterFactory.createSimpleStriping((Color)ShadeAlternateRowsTableCellRenderer.ODD_COLOR));
    }

    public Object getSelectedObject() {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row >= 0 && col >= 0) {
            return this.model.getValueAt(row, col);
        }
        return null;
    }

    @Override
    public Signal objectSelected() {
        return this.dummySignal;
    }

    @Override
    public Signal noObjectSelected() {
        return this.dummySignal;
    }

    @Override
    public Signal objectDoubleClicked() {
        return this.dummySignal;
    }

    @Override
    public Signal objectEdited() {
        return this.dummySignal;
    }

    @Override
    public JComponent getComponent() {
        if (this.holder == null) {
            this.holder = new JPanel(new BorderLayout());
            JScrollPane scrolly = new JScrollPane((Component)this.table);
            this.table.setAutoResizeMode(this.AUTO_RESIZE_MODE);
            this.holder.add((Component)scrolly, "Center");
        }
        return this.holder;
    }

    public List getAllSelectedObjects() {
        return Collections.singletonList(this.getSelectedObject());
    }

    @Override
    public boolean hasSelectedObject() {
        return this.table.getSelectedRow() >= 0 && this.table.getSelectedColumn() >= 0;
    }

    @Override
    public Action getFindAction() {
        return null;
    }

    @Override
    public void addSelectionDependentAction(Action toRegister) {
        this.no();
    }

    @Override
    public void addSelectionChangeListener(ListSelectionListener listener) {
        this.no();
    }

    @Override
    public JXTable getTable() {
        return this.table;
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.no();
    }

    private void no() {
        throw new IllegalStateException("Not implemented. Like everything else in this class, you want it, you implement it.");
    }
}

