/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat;

import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import officemate.components.tableformat.EditableColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ColumnTableFormat
implements WritableTableFormat,
AdvancedTableFormat,
Iterable<ColumnFormat> {
    public final Signal objectEdited = Signals.createSignal(Object.class, (String)"edited object");
    private List<ColumnFormat> columns = new ArrayList<ColumnFormat>();

    public ColumnTableFormat() {
    }

    public ColumnTableFormat(ColumnFormat[] newColumns) {
        this.columns.addAll(Arrays.asList(newColumns));
    }

    public ColumnTableFormat(List<ColumnFormat> newColumns) {
        this.columns.addAll(newColumns);
    }

    public ColumnTableFormat(PropertiedObject.Property[] newColumns) {
        for (int i = 0; i < newColumns.length; ++i) {
            this.addColumn((ColumnFormat)new PropertyColumnFormat(newColumns[i]));
        }
    }

    public ColumnTableFormat addColumn(ColumnFormat toAdd) {
        this.columns.add(toAdd);
        return this;
    }

    public ColumnTableFormat addColumns(List<ColumnFormat> columnsToAdd) {
        this.columns.addAll(columnsToAdd);
        return this;
    }

    public ColumnTableFormat prependColumn(ColumnFormat toPrepend) {
        this.columns.add(0, toPrepend);
        return this;
    }

    public boolean isEditable(Object arg0, int col) {
        return this.columns.get(col) instanceof EditableColumnFormat;
    }

    public Object setColumnValue(Object baseObject, Object editedValue, int column) {
        EditableColumnFormat colFormat = (EditableColumnFormat)this.columns.get(column);
        Object newVal = colFormat.setValue(baseObject, editedValue);
        this.objectEdited.emit(baseObject);
        return newVal;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int column) {
        ColumnFormat format = this.columns.get(column);
        return format.getName();
    }

    public Object getColumnValue(Object baseObject, int column) {
        ColumnFormat format = this.columns.get(column);
        return format.getValue(baseObject);
    }

    public Class getColumnClass(int column) {
        ColumnFormat format = this.columns.get(column);
        return format.getColumnClass();
    }

    public ColumnFormat getColumnFormat(int columnIndex) {
        try {
            return (ColumnFormat)this.columns.get(columnIndex).clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Comparator getColumnComparator(int column) {
        return null;
    }

    @Override
    public Iterator<ColumnFormat> iterator() {
        return this.columns.iterator();
    }

    public List<ColumnFormat> getColumns() {
        return this.columns;
    }
}

