/*
 * Decompiled with CFR 0.152.
 */
package officemate.components.tableformat;

import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.reports.table.ColumnFormat;
import org.jdesktop.swingx.JXTable;

public class ExcelAdapter
implements ActionListener {
    private Clipboard system;
    private StringSelection stsel;
    private JXTable table;
    private ColumnTableFormat tableFormat;
    private EventTableModel tableModel;

    public ExcelAdapter(JXTable newTable, ColumnTableFormat newTableFormat, EventTableModel newTableModel) {
        this.table = newTable;
        this.tableFormat = newTableFormat;
        this.tableModel = newTableModel;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.table.registerKeyboardAction((ActionListener)this, "Copy", copy, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Copy") == 0) {
            this.copy();
        }
    }

    public void copy() {
        StringBuffer sbf = new StringBuffer();
        int allCols = this.table.getColumnCount();
        int numrows = this.table.getSelectedRowCount();
        int[] rowsselected = this.table.getSelectedRows();
        for (int row = 0; row < numrows; ++row) {
            for (int col = 0; col < allCols; ++col) {
                ColumnFormat colFormat = this.tableFormat.getColumnFormat(col);
                Object rowObject = this.tableModel.getElementAt(this.table.convertRowIndexToModel(rowsselected[row]));
                String stringRep = colFormat.getStringValue(rowObject);
                sbf.append(stringRep);
                if (col >= allCols - 1) continue;
                sbf.append("\t");
            }
            sbf.append("\n");
        }
        this.stsel = new StringSelection(sbf.toString());
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.system.setContents(this.stsel, this.stsel);
    }
}

